<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unsubscribe ServiceType
 * @subpackage Services
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class Unsubscribe extends AbstractSoapClientBase
{
    /**
     * Sets the UserSessionCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserSessionCredentials $userSessionCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSessionCredentials(\StructType\UserSessionCredentials $userSessionCredentials, $nameSpace = 'http://www.peoplevox.net/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSessionCredentials', $userSessionCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UnsubscribeEvent
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSessionCredentials
     * - SOAPHeaderNamespaces: http://www.peoplevox.net/
     * - SOAPHeaderTypes: \StructType\UserSessionCredentials
     * - SOAPHeaders: required
     * - documentation: Unsubscribe to an event that was subscribed. | Unsubscribe to an event that was subscribed. | Unsubscribe to an event that was subscribed.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnsubscribeEvent $parameters
     * @return \StructType\UnsubscribeEventResponse|bool
     */
    public function UnsubscribeEvent(\StructType\UnsubscribeEvent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UnsubscribeEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnsubscribeEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
