<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Authenticate
     * Meta informations extracted from the WSDL
     * - documentation: Authenticate user. | Authenticate user. | Authenticate user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Authenticate $parameters
     * @return \StructType\AuthenticateResponse|bool
     */
    public function Authenticate(\StructType\Authenticate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Authenticate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthenticateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
