<?php

namespace http://www.peoplevox.net/\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscribePostEvent StructType
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class SubscribePostEvent extends AbstractStructBase
{
    /**
     * The eventType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $eventType;
    /**
     * The encodeParameterData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $encodeParameterData;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $filter;
    /**
     * The postUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postUrl;
    /**
     * The postParams
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postParams;
    /**
     * Constructor method for SubscribePostEvent
     * @uses SubscribePostEvent::setEventType()
     * @uses SubscribePostEvent::setEncodeParameterData()
     * @uses SubscribePostEvent::setFilter()
     * @uses SubscribePostEvent::setPostUrl()
     * @uses SubscribePostEvent::setPostParams()
     * @param string $eventType
     * @param bool $encodeParameterData
     * @param string $filter
     * @param string $postUrl
     * @param string $postParams
     */
    public function __construct($eventType = null, $encodeParameterData = null, $filter = null, $postUrl = null, $postParams = null)
    {
        $this
            ->setEventType($eventType)
            ->setEncodeParameterData($encodeParameterData)
            ->setFilter($filter)
            ->setPostUrl($postUrl)
            ->setPostParams($postParams);
    }
    /**
     * Get eventType value
     * @return string
     */
    public function getEventType()
    {
        return $this->eventType;
    }
    /**
     * Set eventType value
     * @uses \http://www.peoplevox.net/\EnumType\SubscriptionEventTypes::valueIsValid()
     * @uses \http://www.peoplevox.net/\EnumType\SubscriptionEventTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\http://www.peoplevox.net/\EnumType\SubscriptionEventTypes::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eventType, implode(', ', \http://www.peoplevox.net/\EnumType\SubscriptionEventTypes::getValidValues())), __LINE__);
        }
        $this->eventType = $eventType;
        return $this;
    }
    /**
     * Get encodeParameterData value
     * @return bool
     */
    public function getEncodeParameterData()
    {
        return $this->encodeParameterData;
    }
    /**
     * Set encodeParameterData value
     * @param bool $encodeParameterData
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public function setEncodeParameterData($encodeParameterData = null)
    {
        // validation for constraint: boolean
        if (!is_null($encodeParameterData) && !is_bool($encodeParameterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($encodeParameterData)), __LINE__);
        }
        $this->encodeParameterData = $encodeParameterData;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get postUrl value
     * @return string|null
     */
    public function getPostUrl()
    {
        return $this->postUrl;
    }
    /**
     * Set postUrl value
     * @param string $postUrl
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public function setPostUrl($postUrl = null)
    {
        // validation for constraint: string
        if (!is_null($postUrl) && !is_string($postUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postUrl)), __LINE__);
        }
        $this->postUrl = $postUrl;
        return $this;
    }
    /**
     * Get postParams value
     * @return string|null
     */
    public function getPostParams()
    {
        return $this->postParams;
    }
    /**
     * Set postParams value
     * @param string $postParams
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public function setPostParams($postParams = null)
    {
        // validation for constraint: string
        if (!is_null($postParams) && !is_string($postParams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postParams)), __LINE__);
        }
        $this->postParams = $postParams;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \http://www.peoplevox.net/\StructType\SubscribePostEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
