<?php

namespace http://www.peoplevox.net/\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authenticate StructType
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class Authenticate extends AbstractStructBase
{
    /**
     * The clientId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientId;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for Authenticate
     * @uses Authenticate::setClientId()
     * @uses Authenticate::setUsername()
     * @uses Authenticate::setPassword()
     * @param string $clientId
     * @param string $username
     * @param string $password
     */
    public function __construct($clientId = null, $username = null, $password = null)
    {
        $this
            ->setClientId($clientId)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get clientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param string $clientId
     * @return \http://www.peoplevox.net/\StructType\Authenticate
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \http://www.peoplevox.net/\StructType\Authenticate
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \http://www.peoplevox.net/\StructType\Authenticate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \http://www.peoplevox.net/\StructType\Authenticate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
