<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://wms.peoplevox.net/rng2744/resources/integrationservicev4.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://wms.peoplevox.net/rng2744/resources/integrationservicev4.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \http://www.peoplevox.net/\ClassMap::get(),
);
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \http://www.peoplevox.net/\ServiceType\Authenticate($options);
/**
 * Sample call for Authenticate operation/method
 */
if ($authenticate->Authenticate(new \http://www.peoplevox.net/\StructType\Authenticate()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \http://www.peoplevox.net/\ServiceType\Get($options);
$get->setSoapHeaderUserSessionCredentials(new \http://www.peoplevox.net/\StructType\UserSessionCredentials());
/**
 * Sample call for GetData operation/method
 */
if ($get->GetData(new \http://www.peoplevox.net/\StructType\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSystemSettings operation/method
 */
if ($get->GetSystemSettings(new \http://www.peoplevox.net/\StructType\GetSystemSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportData operation/method
 */
if ($get->GetReportData(new \http://www.peoplevox.net/\StructType\GetReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportColumns operation/method
 */
if ($get->GetReportColumns(new \http://www.peoplevox.net/\StructType\GetReportColumns()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSaveTemplate operation/method
 */
if ($get->GetSaveTemplate(new \http://www.peoplevox.net/\StructType\GetSaveTemplate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \http://www.peoplevox.net/\ServiceType\Save($options);
$save->setSoapHeaderUserSessionCredentials(new \http://www.peoplevox.net/\StructType\UserSessionCredentials());
/**
 * Sample call for SaveData operation/method
 */
if ($save->SaveData(new \http://www.peoplevox.net/\StructType\SaveData()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Subscribe ServiceType
 */
$subscribe = new \http://www.peoplevox.net/\ServiceType\Subscribe($options);
$subscribe->setSoapHeaderUserSessionCredentials(new \http://www.peoplevox.net/\StructType\UserSessionCredentials());
/**
 * Sample call for SubscribeEvent operation/method
 */
if ($subscribe->SubscribeEvent(new \http://www.peoplevox.net/\StructType\SubscribeEvent()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Sample call for SubscribeEventWithSitesFilters operation/method
 */
if ($subscribe->SubscribeEventWithSitesFilters(new \http://www.peoplevox.net/\StructType\SubscribeEventWithSitesFilters()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Sample call for SubscribePostEvent operation/method
 */
if ($subscribe->SubscribePostEvent(new \http://www.peoplevox.net/\StructType\SubscribePostEvent()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Samples for Unsubscribe ServiceType
 */
$unsubscribe = new \http://www.peoplevox.net/\ServiceType\Unsubscribe($options);
$unsubscribe->setSoapHeaderUserSessionCredentials(new \http://www.peoplevox.net/\StructType\UserSessionCredentials());
/**
 * Sample call for UnsubscribeEvent operation/method
 */
if ($unsubscribe->UnsubscribeEvent(new \http://www.peoplevox.net/\StructType\UnsubscribeEvent()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
