<?php

namespace http://www.peoplevox.net/\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSessionCredentials StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UserSessionCredentials
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class UserSessionCredentials extends AbstractStructBase
{
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UserId;
    /**
     * The ClientId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientId;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionId;
    /**
     * Constructor method for UserSessionCredentials
     * @uses UserSessionCredentials::setUserId()
     * @uses UserSessionCredentials::setClientId()
     * @uses UserSessionCredentials::setSessionId()
     * @param int $userId
     * @param string $clientId
     * @param string $sessionId
     */
    public function __construct($userId = null, $clientId = null, $sessionId = null)
    {
        $this
            ->setUserId($userId)
            ->setClientId($clientId)
            ->setSessionId($sessionId);
    }
    /**
     * Get UserId value
     * @return int
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \http://www.peoplevox.net/\StructType\UserSessionCredentials
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \http://www.peoplevox.net/\StructType\UserSessionCredentials
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientId)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \http://www.peoplevox.net/\StructType\UserSessionCredentials
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \http://www.peoplevox.net/\StructType\UserSessionCredentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
