<?php

namespace http://www.peoplevox.net/\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationStatusResponse StructType
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class IntegrationStatusResponse extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The LineNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNo;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Details;
    /**
     * Constructor method for IntegrationStatusResponse
     * @uses IntegrationStatusResponse::setStatus()
     * @uses IntegrationStatusResponse::setLineNo()
     * @uses IntegrationStatusResponse::setReference()
     * @uses IntegrationStatusResponse::setDetails()
     * @param string $status
     * @param int $lineNo
     * @param string $reference
     * @param string $details
     */
    public function __construct($status = null, $lineNo = null, $reference = null, $details = null)
    {
        $this
            ->setStatus($status)
            ->setLineNo($lineNo)
            ->setReference($reference)
            ->setDetails($details);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \http://www.peoplevox.net/\EnumType\IntegrationResponseStatuses::valueIsValid()
     * @uses \http://www.peoplevox.net/\EnumType\IntegrationResponseStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \http://www.peoplevox.net/\StructType\IntegrationStatusResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\http://www.peoplevox.net/\EnumType\IntegrationResponseStatuses::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \http://www.peoplevox.net/\EnumType\IntegrationResponseStatuses::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LineNo value
     * @return int
     */
    public function getLineNo()
    {
        return $this->LineNo;
    }
    /**
     * Set LineNo value
     * @param int $lineNo
     * @return \http://www.peoplevox.net/\StructType\IntegrationStatusResponse
     */
    public function setLineNo($lineNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !is_numeric($lineNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNo)), __LINE__);
        }
        $this->LineNo = $lineNo;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \http://www.peoplevox.net/\StructType\IntegrationStatusResponse
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Details value
     * @return string|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param string $details
     * @return \http://www.peoplevox.net/\StructType\IntegrationStatusResponse
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($details)), __LINE__);
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \http://www.peoplevox.net/\StructType\IntegrationStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
