<?php

namespace http://www.peoplevox.net/\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IntegrationResponse
 * @subpackage Structs
 * @Authors Georgi Georgiev, Rihards @dExIT@ Mantejs
 * @Version 0.1
 * @Date 14/06/2018
 */
class IntegrationResponse extends AbstractStructBase
{
    /**
     * The ResponseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponseId;
    /**
     * The TotalCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalCount;
    /**
     * The ImportingQueueId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ImportingQueueId;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Detail;
    /**
     * The Statuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse
     */
    public $Statuses;
    /**
     * The SalesOrdersToDespatchIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \http://www.peoplevox.net/\ArrayType\ArrayOfInt
     */
    public $SalesOrdersToDespatchIds;
    /**
     * Constructor method for IntegrationResponse
     * @uses IntegrationResponse::setResponseId()
     * @uses IntegrationResponse::setTotalCount()
     * @uses IntegrationResponse::setImportingQueueId()
     * @uses IntegrationResponse::setDetail()
     * @uses IntegrationResponse::setStatuses()
     * @uses IntegrationResponse::setSalesOrdersToDespatchIds()
     * @param int $responseId
     * @param int $totalCount
     * @param int $importingQueueId
     * @param string $detail
     * @param \http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse $statuses
     * @param \http://www.peoplevox.net/\ArrayType\ArrayOfInt $salesOrdersToDespatchIds
     */
    public function __construct($responseId = null, $totalCount = null, $importingQueueId = null, $detail = null, \http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse $statuses = null, \http://www.peoplevox.net/\ArrayType\ArrayOfInt $salesOrdersToDespatchIds = null)
    {
        $this
            ->setResponseId($responseId)
            ->setTotalCount($totalCount)
            ->setImportingQueueId($importingQueueId)
            ->setDetail($detail)
            ->setStatuses($statuses)
            ->setSalesOrdersToDespatchIds($salesOrdersToDespatchIds);
    }
    /**
     * Get ResponseId value
     * @return int
     */
    public function getResponseId()
    {
        return $this->ResponseId;
    }
    /**
     * Set ResponseId value
     * @param int $responseId
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setResponseId($responseId = null)
    {
        // validation for constraint: int
        if (!is_null($responseId) && !is_numeric($responseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseId)), __LINE__);
        }
        $this->ResponseId = $responseId;
        return $this;
    }
    /**
     * Get TotalCount value
     * @return int
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }
    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !is_numeric($totalCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalCount)), __LINE__);
        }
        $this->TotalCount = $totalCount;
        return $this;
    }
    /**
     * Get ImportingQueueId value
     * @return int
     */
    public function getImportingQueueId()
    {
        return $this->ImportingQueueId;
    }
    /**
     * Set ImportingQueueId value
     * @param int $importingQueueId
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setImportingQueueId($importingQueueId = null)
    {
        // validation for constraint: int
        if (!is_null($importingQueueId) && !is_numeric($importingQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importingQueueId)), __LINE__);
        }
        $this->ImportingQueueId = $importingQueueId;
        return $this;
    }
    /**
     * Get Detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param string $detail
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse $statuses
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setStatuses(\http://www.peoplevox.net/\ArrayType\ArrayOfIntegrationStatusResponse $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Get SalesOrdersToDespatchIds value
     * @return \http://www.peoplevox.net/\ArrayType\ArrayOfInt|null
     */
    public function getSalesOrdersToDespatchIds()
    {
        return $this->SalesOrdersToDespatchIds;
    }
    /**
     * Set SalesOrdersToDespatchIds value
     * @param \http://www.peoplevox.net/\ArrayType\ArrayOfInt $salesOrdersToDespatchIds
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public function setSalesOrdersToDespatchIds(\http://www.peoplevox.net/\ArrayType\ArrayOfInt $salesOrdersToDespatchIds = null)
    {
        $this->SalesOrdersToDespatchIds = $salesOrdersToDespatchIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \http://www.peoplevox.net/\StructType\IntegrationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
