<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneNumberOverview StructType
 * @subpackage Structs
 */
class PhoneNumberOverview extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - pattern: [\d]{1,}
     * - type: np:PhoneNumber
     * @var string
     */
    public $PhoneNumber;
    /**
     * The NRAStatusInCRDB
     * @var string
     */
    public $NRAStatusInCRDB;
    /**
     * The PhoneNumberStatus
     * Meta informations extracted from the WSDL
     * - type: np:PhoneNumberStatus
     * @var string
     */
    public $PhoneNumberStatus;
    /**
     * The PhoneNumberStatusDescription
     * @var string
     */
    public $PhoneNumberStatusDescription;
    /**
     * The PhoneNumberStatusDateTime
     * @var string
     */
    public $PhoneNumberStatusDateTime;
    /**
     * The PortingInProgress
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $PortingInProgress;
    /**
     * The NumberType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - type: np:NumberType
     * @var int
     */
    public $NumberType;
    /**
     * The NumberTypeDescription
     * @var string
     */
    public $NumberTypeDescription;
    /**
     * The OriginalOperator
     * @var string
     */
    public $OriginalOperator;
    /**
     * The OriginalOperatorDescription
     * @var string
     */
    public $OriginalOperatorDescription;
    /**
     * The ServingOperator
     * @var string
     */
    public $ServingOperator;
    /**
     * The ServingOperatorDescription
     * @var string
     */
    public $ServingOperatorDescription;
    /**
     * The ServingServiceProvider
     * @var string
     */
    public $ServingServiceProvider;
    /**
     * The ServingServiceProviderDescription
     * @var string
     */
    public $ServingServiceProviderDescription;
    /**
     * The PointOfPresence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - type: np:PointOfPresence
     * @var string
     */
    public $PointOfPresence;
    /**
     * The PointOfPresenceDescription
     * @var string
     */
    public $PointOfPresenceDescription;
    /**
     * The TariffDate
     * @var string
     */
    public $TariffDate;
    /**
     * The TariffId
     * @var int
     */
    public $TariffId;
    /**
     * The TariffText
     * @var string
     */
    public $TariffText;
    /**
     * The PlannedMutationInProgress
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $PlannedMutationInProgress;
    /**
     * The AIResult
     * @var string
     */
    public $AIResult;
    /**
     * The ConnectionKey
     * @var string
     */
    public $ConnectionKey;
    /**
     * The PrintName
     * @var string
     */
    public $PrintName;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The Prefix
     * @var string
     */
    public $Prefix;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The AddFirstName
     * @var string
     */
    public $AddFirstName;
    /**
     * The AddPrefix
     * @var string
     */
    public $AddPrefix;
    /**
     * The AddLastName
     * @var string
     */
    public $AddLastName;
    /**
     * The Street
     * @var string
     */
    public $Street;
    /**
     * The HouseNumber
     * @var string
     */
    public $HouseNumber;
    /**
     * The HouseNumberAddition
     * @var string
     */
    public $HouseNumberAddition;
    /**
     * The ResidenceName
     * @var string
     */
    public $ResidenceName;
    /**
     * The PropertyIndicator
     * @var string
     */
    public $PropertyIndicator;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The Postcode
     * @var string
     */
    public $Postcode;
    /**
     * The Flag1
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag1;
    /**
     * The Flag2
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag2;
    /**
     * The Flag3
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag3;
    /**
     * The Flag4
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag4;
    /**
     * The Flag5
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag5;
    /**
     * The Flag6
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag6;
    /**
     * The Flag7
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag7;
    /**
     * The Flag8
     * Meta informations extracted from the WSDL
     * - pattern: [Y|N]
     * @var string
     */
    public $Flag8;
    /**
     * The UsageFlag
     * @var string
     */
    public $UsageFlag;
    /**
     * The DeletePlanDateTime
     * @var string
     */
    public $DeletePlanDateTime;
    /**
     * Constructor method for PhoneNumberOverview
     * @uses PhoneNumberOverview::setPhoneNumber()
     * @uses PhoneNumberOverview::setNRAStatusInCRDB()
     * @uses PhoneNumberOverview::setPhoneNumberStatus()
     * @uses PhoneNumberOverview::setPhoneNumberStatusDescription()
     * @uses PhoneNumberOverview::setPhoneNumberStatusDateTime()
     * @uses PhoneNumberOverview::setPortingInProgress()
     * @uses PhoneNumberOverview::setNumberType()
     * @uses PhoneNumberOverview::setNumberTypeDescription()
     * @uses PhoneNumberOverview::setOriginalOperator()
     * @uses PhoneNumberOverview::setOriginalOperatorDescription()
     * @uses PhoneNumberOverview::setServingOperator()
     * @uses PhoneNumberOverview::setServingOperatorDescription()
     * @uses PhoneNumberOverview::setServingServiceProvider()
     * @uses PhoneNumberOverview::setServingServiceProviderDescription()
     * @uses PhoneNumberOverview::setPointOfPresence()
     * @uses PhoneNumberOverview::setPointOfPresenceDescription()
     * @uses PhoneNumberOverview::setTariffDate()
     * @uses PhoneNumberOverview::setTariffId()
     * @uses PhoneNumberOverview::setTariffText()
     * @uses PhoneNumberOverview::setPlannedMutationInProgress()
     * @uses PhoneNumberOverview::setAIResult()
     * @uses PhoneNumberOverview::setConnectionKey()
     * @uses PhoneNumberOverview::setPrintName()
     * @uses PhoneNumberOverview::setFirstName()
     * @uses PhoneNumberOverview::setPrefix()
     * @uses PhoneNumberOverview::setLastName()
     * @uses PhoneNumberOverview::setAddFirstName()
     * @uses PhoneNumberOverview::setAddPrefix()
     * @uses PhoneNumberOverview::setAddLastName()
     * @uses PhoneNumberOverview::setStreet()
     * @uses PhoneNumberOverview::setHouseNumber()
     * @uses PhoneNumberOverview::setHouseNumberAddition()
     * @uses PhoneNumberOverview::setResidenceName()
     * @uses PhoneNumberOverview::setPropertyIndicator()
     * @uses PhoneNumberOverview::setCity()
     * @uses PhoneNumberOverview::setPostcode()
     * @uses PhoneNumberOverview::setFlag1()
     * @uses PhoneNumberOverview::setFlag2()
     * @uses PhoneNumberOverview::setFlag3()
     * @uses PhoneNumberOverview::setFlag4()
     * @uses PhoneNumberOverview::setFlag5()
     * @uses PhoneNumberOverview::setFlag6()
     * @uses PhoneNumberOverview::setFlag7()
     * @uses PhoneNumberOverview::setFlag8()
     * @uses PhoneNumberOverview::setUsageFlag()
     * @uses PhoneNumberOverview::setDeletePlanDateTime()
     * @param string $phoneNumber
     * @param string $nRAStatusInCRDB
     * @param string $phoneNumberStatus
     * @param string $phoneNumberStatusDescription
     * @param string $phoneNumberStatusDateTime
     * @param string $portingInProgress
     * @param int $numberType
     * @param string $numberTypeDescription
     * @param string $originalOperator
     * @param string $originalOperatorDescription
     * @param string $servingOperator
     * @param string $servingOperatorDescription
     * @param string $servingServiceProvider
     * @param string $servingServiceProviderDescription
     * @param string $pointOfPresence
     * @param string $pointOfPresenceDescription
     * @param string $tariffDate
     * @param int $tariffId
     * @param string $tariffText
     * @param string $plannedMutationInProgress
     * @param string $aIResult
     * @param string $connectionKey
     * @param string $printName
     * @param string $firstName
     * @param string $prefix
     * @param string $lastName
     * @param string $addFirstName
     * @param string $addPrefix
     * @param string $addLastName
     * @param string $street
     * @param string $houseNumber
     * @param string $houseNumberAddition
     * @param string $residenceName
     * @param string $propertyIndicator
     * @param string $city
     * @param string $postcode
     * @param string $flag1
     * @param string $flag2
     * @param string $flag3
     * @param string $flag4
     * @param string $flag5
     * @param string $flag6
     * @param string $flag7
     * @param string $flag8
     * @param string $usageFlag
     * @param string $deletePlanDateTime
     */
    public function __construct($phoneNumber = null, $nRAStatusInCRDB = null, $phoneNumberStatus = null, $phoneNumberStatusDescription = null, $phoneNumberStatusDateTime = null, $portingInProgress = null, $numberType = null, $numberTypeDescription = null, $originalOperator = null, $originalOperatorDescription = null, $servingOperator = null, $servingOperatorDescription = null, $servingServiceProvider = null, $servingServiceProviderDescription = null, $pointOfPresence = null, $pointOfPresenceDescription = null, $tariffDate = null, $tariffId = null, $tariffText = null, $plannedMutationInProgress = null, $aIResult = null, $connectionKey = null, $printName = null, $firstName = null, $prefix = null, $lastName = null, $addFirstName = null, $addPrefix = null, $addLastName = null, $street = null, $houseNumber = null, $houseNumberAddition = null, $residenceName = null, $propertyIndicator = null, $city = null, $postcode = null, $flag1 = null, $flag2 = null, $flag3 = null, $flag4 = null, $flag5 = null, $flag6 = null, $flag7 = null, $flag8 = null, $usageFlag = null, $deletePlanDateTime = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setNRAStatusInCRDB($nRAStatusInCRDB)
            ->setPhoneNumberStatus($phoneNumberStatus)
            ->setPhoneNumberStatusDescription($phoneNumberStatusDescription)
            ->setPhoneNumberStatusDateTime($phoneNumberStatusDateTime)
            ->setPortingInProgress($portingInProgress)
            ->setNumberType($numberType)
            ->setNumberTypeDescription($numberTypeDescription)
            ->setOriginalOperator($originalOperator)
            ->setOriginalOperatorDescription($originalOperatorDescription)
            ->setServingOperator($servingOperator)
            ->setServingOperatorDescription($servingOperatorDescription)
            ->setServingServiceProvider($servingServiceProvider)
            ->setServingServiceProviderDescription($servingServiceProviderDescription)
            ->setPointOfPresence($pointOfPresence)
            ->setPointOfPresenceDescription($pointOfPresenceDescription)
            ->setTariffDate($tariffDate)
            ->setTariffId($tariffId)
            ->setTariffText($tariffText)
            ->setPlannedMutationInProgress($plannedMutationInProgress)
            ->setAIResult($aIResult)
            ->setConnectionKey($connectionKey)
            ->setPrintName($printName)
            ->setFirstName($firstName)
            ->setPrefix($prefix)
            ->setLastName($lastName)
            ->setAddFirstName($addFirstName)
            ->setAddPrefix($addPrefix)
            ->setAddLastName($addLastName)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setHouseNumberAddition($houseNumberAddition)
            ->setResidenceName($residenceName)
            ->setPropertyIndicator($propertyIndicator)
            ->setCity($city)
            ->setPostcode($postcode)
            ->setFlag1($flag1)
            ->setFlag2($flag2)
            ->setFlag3($flag3)
            ->setFlag4($flag4)
            ->setFlag5($flag5)
            ->setFlag6($flag6)
            ->setFlag7($flag7)
            ->setFlag8($flag8)
            ->setUsageFlag($usageFlag)
            ->setDeletePlanDateTime($deletePlanDateTime);
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\PhoneNumberOverview
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($phoneNumber) && !preg_match('/[\\d]{1,}/', $phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\d]{1,}", "%s" given', var_export($phoneNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get NRAStatusInCRDB value
     * @return string|null
     */
    public function getNRAStatusInCRDB()
    {
        return $this->NRAStatusInCRDB;
    }
    /**
     * Set NRAStatusInCRDB value
     * @param string $nRAStatusInCRDB
     * @return \StructType\PhoneNumberOverview
     */
    public function setNRAStatusInCRDB($nRAStatusInCRDB = null)
    {
        // validation for constraint: string
        if (!is_null($nRAStatusInCRDB) && !is_string($nRAStatusInCRDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nRAStatusInCRDB)), __LINE__);
        }
        $this->NRAStatusInCRDB = $nRAStatusInCRDB;
        return $this;
    }
    /**
     * Get PhoneNumberStatus value
     * @return string|null
     */
    public function getPhoneNumberStatus()
    {
        return $this->PhoneNumberStatus;
    }
    /**
     * Set PhoneNumberStatus value
     * @param string $phoneNumberStatus
     * @return \StructType\PhoneNumberOverview
     */
    public function setPhoneNumberStatus($phoneNumberStatus = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumberStatus) && !is_string($phoneNumberStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumberStatus)), __LINE__);
        }
        $this->PhoneNumberStatus = $phoneNumberStatus;
        return $this;
    }
    /**
     * Get PhoneNumberStatusDescription value
     * @return string|null
     */
    public function getPhoneNumberStatusDescription()
    {
        return $this->PhoneNumberStatusDescription;
    }
    /**
     * Set PhoneNumberStatusDescription value
     * @param string $phoneNumberStatusDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setPhoneNumberStatusDescription($phoneNumberStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumberStatusDescription) && !is_string($phoneNumberStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumberStatusDescription)), __LINE__);
        }
        $this->PhoneNumberStatusDescription = $phoneNumberStatusDescription;
        return $this;
    }
    /**
     * Get PhoneNumberStatusDateTime value
     * @return string|null
     */
    public function getPhoneNumberStatusDateTime()
    {
        return $this->PhoneNumberStatusDateTime;
    }
    /**
     * Set PhoneNumberStatusDateTime value
     * @param string $phoneNumberStatusDateTime
     * @return \StructType\PhoneNumberOverview
     */
    public function setPhoneNumberStatusDateTime($phoneNumberStatusDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumberStatusDateTime) && !is_string($phoneNumberStatusDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumberStatusDateTime)), __LINE__);
        }
        $this->PhoneNumberStatusDateTime = $phoneNumberStatusDateTime;
        return $this;
    }
    /**
     * Get PortingInProgress value
     * @return string|null
     */
    public function getPortingInProgress()
    {
        return $this->PortingInProgress;
    }
    /**
     * Set PortingInProgress value
     * @param string $portingInProgress
     * @return \StructType\PhoneNumberOverview
     */
    public function setPortingInProgress($portingInProgress = null)
    {
        // validation for constraint: pattern
        if (is_scalar($portingInProgress) && !preg_match('/[Y|N]/', $portingInProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($portingInProgress, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($portingInProgress) && !is_string($portingInProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portingInProgress)), __LINE__);
        }
        $this->PortingInProgress = $portingInProgress;
        return $this;
    }
    /**
     * Get NumberType value
     * @return int|null
     */
    public function getNumberType()
    {
        return $this->NumberType;
    }
    /**
     * Set NumberType value
     * @param int $numberType
     * @return \StructType\PhoneNumberOverview
     */
    public function setNumberType($numberType = null)
    {
        // validation for constraint: int
        if (!is_null($numberType) && !is_numeric($numberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberType)), __LINE__);
        }
        $this->NumberType = $numberType;
        return $this;
    }
    /**
     * Get NumberTypeDescription value
     * @return string|null
     */
    public function getNumberTypeDescription()
    {
        return $this->NumberTypeDescription;
    }
    /**
     * Set NumberTypeDescription value
     * @param string $numberTypeDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setNumberTypeDescription($numberTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($numberTypeDescription) && !is_string($numberTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberTypeDescription)), __LINE__);
        }
        $this->NumberTypeDescription = $numberTypeDescription;
        return $this;
    }
    /**
     * Get OriginalOperator value
     * @return string|null
     */
    public function getOriginalOperator()
    {
        return $this->OriginalOperator;
    }
    /**
     * Set OriginalOperator value
     * @param string $originalOperator
     * @return \StructType\PhoneNumberOverview
     */
    public function setOriginalOperator($originalOperator = null)
    {
        // validation for constraint: string
        if (!is_null($originalOperator) && !is_string($originalOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalOperator)), __LINE__);
        }
        $this->OriginalOperator = $originalOperator;
        return $this;
    }
    /**
     * Get OriginalOperatorDescription value
     * @return string|null
     */
    public function getOriginalOperatorDescription()
    {
        return $this->OriginalOperatorDescription;
    }
    /**
     * Set OriginalOperatorDescription value
     * @param string $originalOperatorDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setOriginalOperatorDescription($originalOperatorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($originalOperatorDescription) && !is_string($originalOperatorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalOperatorDescription)), __LINE__);
        }
        $this->OriginalOperatorDescription = $originalOperatorDescription;
        return $this;
    }
    /**
     * Get ServingOperator value
     * @return string|null
     */
    public function getServingOperator()
    {
        return $this->ServingOperator;
    }
    /**
     * Set ServingOperator value
     * @param string $servingOperator
     * @return \StructType\PhoneNumberOverview
     */
    public function setServingOperator($servingOperator = null)
    {
        // validation for constraint: string
        if (!is_null($servingOperator) && !is_string($servingOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servingOperator)), __LINE__);
        }
        $this->ServingOperator = $servingOperator;
        return $this;
    }
    /**
     * Get ServingOperatorDescription value
     * @return string|null
     */
    public function getServingOperatorDescription()
    {
        return $this->ServingOperatorDescription;
    }
    /**
     * Set ServingOperatorDescription value
     * @param string $servingOperatorDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setServingOperatorDescription($servingOperatorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($servingOperatorDescription) && !is_string($servingOperatorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servingOperatorDescription)), __LINE__);
        }
        $this->ServingOperatorDescription = $servingOperatorDescription;
        return $this;
    }
    /**
     * Get ServingServiceProvider value
     * @return string|null
     */
    public function getServingServiceProvider()
    {
        return $this->ServingServiceProvider;
    }
    /**
     * Set ServingServiceProvider value
     * @param string $servingServiceProvider
     * @return \StructType\PhoneNumberOverview
     */
    public function setServingServiceProvider($servingServiceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($servingServiceProvider) && !is_string($servingServiceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servingServiceProvider)), __LINE__);
        }
        $this->ServingServiceProvider = $servingServiceProvider;
        return $this;
    }
    /**
     * Get ServingServiceProviderDescription value
     * @return string|null
     */
    public function getServingServiceProviderDescription()
    {
        return $this->ServingServiceProviderDescription;
    }
    /**
     * Set ServingServiceProviderDescription value
     * @param string $servingServiceProviderDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setServingServiceProviderDescription($servingServiceProviderDescription = null)
    {
        // validation for constraint: string
        if (!is_null($servingServiceProviderDescription) && !is_string($servingServiceProviderDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servingServiceProviderDescription)), __LINE__);
        }
        $this->ServingServiceProviderDescription = $servingServiceProviderDescription;
        return $this;
    }
    /**
     * Get PointOfPresence value
     * @return string|null
     */
    public function getPointOfPresence()
    {
        return $this->PointOfPresence;
    }
    /**
     * Set PointOfPresence value
     * @param string $pointOfPresence
     * @return \StructType\PhoneNumberOverview
     */
    public function setPointOfPresence($pointOfPresence = null)
    {
        // validation for constraint: string
        if (!is_null($pointOfPresence) && !is_string($pointOfPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pointOfPresence)), __LINE__);
        }
        $this->PointOfPresence = $pointOfPresence;
        return $this;
    }
    /**
     * Get PointOfPresenceDescription value
     * @return string|null
     */
    public function getPointOfPresenceDescription()
    {
        return $this->PointOfPresenceDescription;
    }
    /**
     * Set PointOfPresenceDescription value
     * @param string $pointOfPresenceDescription
     * @return \StructType\PhoneNumberOverview
     */
    public function setPointOfPresenceDescription($pointOfPresenceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($pointOfPresenceDescription) && !is_string($pointOfPresenceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pointOfPresenceDescription)), __LINE__);
        }
        $this->PointOfPresenceDescription = $pointOfPresenceDescription;
        return $this;
    }
    /**
     * Get TariffDate value
     * @return string|null
     */
    public function getTariffDate()
    {
        return $this->TariffDate;
    }
    /**
     * Set TariffDate value
     * @param string $tariffDate
     * @return \StructType\PhoneNumberOverview
     */
    public function setTariffDate($tariffDate = null)
    {
        // validation for constraint: string
        if (!is_null($tariffDate) && !is_string($tariffDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffDate)), __LINE__);
        }
        $this->TariffDate = $tariffDate;
        return $this;
    }
    /**
     * Get TariffId value
     * @return int|null
     */
    public function getTariffId()
    {
        return $this->TariffId;
    }
    /**
     * Set TariffId value
     * @param int $tariffId
     * @return \StructType\PhoneNumberOverview
     */
    public function setTariffId($tariffId = null)
    {
        // validation for constraint: int
        if (!is_null($tariffId) && !is_numeric($tariffId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tariffId)), __LINE__);
        }
        $this->TariffId = $tariffId;
        return $this;
    }
    /**
     * Get TariffText value
     * @return string|null
     */
    public function getTariffText()
    {
        return $this->TariffText;
    }
    /**
     * Set TariffText value
     * @param string $tariffText
     * @return \StructType\PhoneNumberOverview
     */
    public function setTariffText($tariffText = null)
    {
        // validation for constraint: string
        if (!is_null($tariffText) && !is_string($tariffText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffText)), __LINE__);
        }
        $this->TariffText = $tariffText;
        return $this;
    }
    /**
     * Get PlannedMutationInProgress value
     * @return string|null
     */
    public function getPlannedMutationInProgress()
    {
        return $this->PlannedMutationInProgress;
    }
    /**
     * Set PlannedMutationInProgress value
     * @param string $plannedMutationInProgress
     * @return \StructType\PhoneNumberOverview
     */
    public function setPlannedMutationInProgress($plannedMutationInProgress = null)
    {
        // validation for constraint: pattern
        if (is_scalar($plannedMutationInProgress) && !preg_match('/[Y|N]/', $plannedMutationInProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($plannedMutationInProgress, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($plannedMutationInProgress) && !is_string($plannedMutationInProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plannedMutationInProgress)), __LINE__);
        }
        $this->PlannedMutationInProgress = $plannedMutationInProgress;
        return $this;
    }
    /**
     * Get AIResult value
     * @return string|null
     */
    public function getAIResult()
    {
        return $this->AIResult;
    }
    /**
     * Set AIResult value
     * @param string $aIResult
     * @return \StructType\PhoneNumberOverview
     */
    public function setAIResult($aIResult = null)
    {
        // validation for constraint: string
        if (!is_null($aIResult) && !is_string($aIResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aIResult)), __LINE__);
        }
        $this->AIResult = $aIResult;
        return $this;
    }
    /**
     * Get ConnectionKey value
     * @return string|null
     */
    public function getConnectionKey()
    {
        return $this->ConnectionKey;
    }
    /**
     * Set ConnectionKey value
     * @param string $connectionKey
     * @return \StructType\PhoneNumberOverview
     */
    public function setConnectionKey($connectionKey = null)
    {
        // validation for constraint: string
        if (!is_null($connectionKey) && !is_string($connectionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionKey)), __LINE__);
        }
        $this->ConnectionKey = $connectionKey;
        return $this;
    }
    /**
     * Get PrintName value
     * @return string|null
     */
    public function getPrintName()
    {
        return $this->PrintName;
    }
    /**
     * Set PrintName value
     * @param string $printName
     * @return \StructType\PhoneNumberOverview
     */
    public function setPrintName($printName = null)
    {
        // validation for constraint: string
        if (!is_null($printName) && !is_string($printName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($printName)), __LINE__);
        }
        $this->PrintName = $printName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\PhoneNumberOverview
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\PhoneNumberOverview
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\PhoneNumberOverview
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get AddFirstName value
     * @return string|null
     */
    public function getAddFirstName()
    {
        return $this->AddFirstName;
    }
    /**
     * Set AddFirstName value
     * @param string $addFirstName
     * @return \StructType\PhoneNumberOverview
     */
    public function setAddFirstName($addFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($addFirstName) && !is_string($addFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addFirstName)), __LINE__);
        }
        $this->AddFirstName = $addFirstName;
        return $this;
    }
    /**
     * Get AddPrefix value
     * @return string|null
     */
    public function getAddPrefix()
    {
        return $this->AddPrefix;
    }
    /**
     * Set AddPrefix value
     * @param string $addPrefix
     * @return \StructType\PhoneNumberOverview
     */
    public function setAddPrefix($addPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($addPrefix) && !is_string($addPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addPrefix)), __LINE__);
        }
        $this->AddPrefix = $addPrefix;
        return $this;
    }
    /**
     * Get AddLastName value
     * @return string|null
     */
    public function getAddLastName()
    {
        return $this->AddLastName;
    }
    /**
     * Set AddLastName value
     * @param string $addLastName
     * @return \StructType\PhoneNumberOverview
     */
    public function setAddLastName($addLastName = null)
    {
        // validation for constraint: string
        if (!is_null($addLastName) && !is_string($addLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addLastName)), __LINE__);
        }
        $this->AddLastName = $addLastName;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\PhoneNumberOverview
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \StructType\PhoneNumberOverview
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get HouseNumberAddition value
     * @return string|null
     */
    public function getHouseNumberAddition()
    {
        return $this->HouseNumberAddition;
    }
    /**
     * Set HouseNumberAddition value
     * @param string $houseNumberAddition
     * @return \StructType\PhoneNumberOverview
     */
    public function setHouseNumberAddition($houseNumberAddition = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumberAddition) && !is_string($houseNumberAddition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumberAddition)), __LINE__);
        }
        $this->HouseNumberAddition = $houseNumberAddition;
        return $this;
    }
    /**
     * Get ResidenceName value
     * @return string|null
     */
    public function getResidenceName()
    {
        return $this->ResidenceName;
    }
    /**
     * Set ResidenceName value
     * @param string $residenceName
     * @return \StructType\PhoneNumberOverview
     */
    public function setResidenceName($residenceName = null)
    {
        // validation for constraint: string
        if (!is_null($residenceName) && !is_string($residenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($residenceName)), __LINE__);
        }
        $this->ResidenceName = $residenceName;
        return $this;
    }
    /**
     * Get PropertyIndicator value
     * @return string|null
     */
    public function getPropertyIndicator()
    {
        return $this->PropertyIndicator;
    }
    /**
     * Set PropertyIndicator value
     * @param string $propertyIndicator
     * @return \StructType\PhoneNumberOverview
     */
    public function setPropertyIndicator($propertyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($propertyIndicator) && !is_string($propertyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyIndicator)), __LINE__);
        }
        $this->PropertyIndicator = $propertyIndicator;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PhoneNumberOverview
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\PhoneNumberOverview
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Flag1 value
     * @return string|null
     */
    public function getFlag1()
    {
        return $this->Flag1;
    }
    /**
     * Set Flag1 value
     * @param string $flag1
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag1($flag1 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag1) && !preg_match('/[Y|N]/', $flag1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag1, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag1) && !is_string($flag1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag1)), __LINE__);
        }
        $this->Flag1 = $flag1;
        return $this;
    }
    /**
     * Get Flag2 value
     * @return string|null
     */
    public function getFlag2()
    {
        return $this->Flag2;
    }
    /**
     * Set Flag2 value
     * @param string $flag2
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag2($flag2 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag2) && !preg_match('/[Y|N]/', $flag2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag2, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag2) && !is_string($flag2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag2)), __LINE__);
        }
        $this->Flag2 = $flag2;
        return $this;
    }
    /**
     * Get Flag3 value
     * @return string|null
     */
    public function getFlag3()
    {
        return $this->Flag3;
    }
    /**
     * Set Flag3 value
     * @param string $flag3
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag3($flag3 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag3) && !preg_match('/[Y|N]/', $flag3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag3, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag3) && !is_string($flag3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag3)), __LINE__);
        }
        $this->Flag3 = $flag3;
        return $this;
    }
    /**
     * Get Flag4 value
     * @return string|null
     */
    public function getFlag4()
    {
        return $this->Flag4;
    }
    /**
     * Set Flag4 value
     * @param string $flag4
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag4($flag4 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag4) && !preg_match('/[Y|N]/', $flag4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag4, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag4) && !is_string($flag4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag4)), __LINE__);
        }
        $this->Flag4 = $flag4;
        return $this;
    }
    /**
     * Get Flag5 value
     * @return string|null
     */
    public function getFlag5()
    {
        return $this->Flag5;
    }
    /**
     * Set Flag5 value
     * @param string $flag5
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag5($flag5 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag5) && !preg_match('/[Y|N]/', $flag5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag5, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag5) && !is_string($flag5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag5)), __LINE__);
        }
        $this->Flag5 = $flag5;
        return $this;
    }
    /**
     * Get Flag6 value
     * @return string|null
     */
    public function getFlag6()
    {
        return $this->Flag6;
    }
    /**
     * Set Flag6 value
     * @param string $flag6
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag6($flag6 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag6) && !preg_match('/[Y|N]/', $flag6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag6, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag6) && !is_string($flag6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag6)), __LINE__);
        }
        $this->Flag6 = $flag6;
        return $this;
    }
    /**
     * Get Flag7 value
     * @return string|null
     */
    public function getFlag7()
    {
        return $this->Flag7;
    }
    /**
     * Set Flag7 value
     * @param string $flag7
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag7($flag7 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag7) && !preg_match('/[Y|N]/', $flag7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag7, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag7) && !is_string($flag7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag7)), __LINE__);
        }
        $this->Flag7 = $flag7;
        return $this;
    }
    /**
     * Get Flag8 value
     * @return string|null
     */
    public function getFlag8()
    {
        return $this->Flag8;
    }
    /**
     * Set Flag8 value
     * @param string $flag8
     * @return \StructType\PhoneNumberOverview
     */
    public function setFlag8($flag8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($flag8) && !preg_match('/[Y|N]/', $flag8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($flag8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flag8) && !is_string($flag8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag8)), __LINE__);
        }
        $this->Flag8 = $flag8;
        return $this;
    }
    /**
     * Get UsageFlag value
     * @return string|null
     */
    public function getUsageFlag()
    {
        return $this->UsageFlag;
    }
    /**
     * Set UsageFlag value
     * @param string $usageFlag
     * @return \StructType\PhoneNumberOverview
     */
    public function setUsageFlag($usageFlag = null)
    {
        // validation for constraint: string
        if (!is_null($usageFlag) && !is_string($usageFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageFlag)), __LINE__);
        }
        $this->UsageFlag = $usageFlag;
        return $this;
    }
    /**
     * Get DeletePlanDateTime value
     * @return string|null
     */
    public function getDeletePlanDateTime()
    {
        return $this->DeletePlanDateTime;
    }
    /**
     * Set DeletePlanDateTime value
     * @param string $deletePlanDateTime
     * @return \StructType\PhoneNumberOverview
     */
    public function setDeletePlanDateTime($deletePlanDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($deletePlanDateTime) && !is_string($deletePlanDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deletePlanDateTime)), __LINE__);
        }
        $this->DeletePlanDateTime = $deletePlanDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhoneNumberOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
