<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneNumberOverviewRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: retrieve the status details for the provided (telephone) number.
 * @subpackage Structs
 */
class GetPhoneNumberOverviewRequest extends AbstractStructBase
{
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - pattern: [\d]{1,}
     * - type: np:PhoneNumber
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 2
     * @var string
     */
    public $Language;
    /**
     * The TariffDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TariffDate;
    /**
     * The IncludeAI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [Y|N]
     * @var string
     */
    public $IncludeAI;
    /**
     * Constructor method for GetPhoneNumberOverviewRequest
     * @uses GetPhoneNumberOverviewRequest::setPhoneNumber()
     * @uses GetPhoneNumberOverviewRequest::setLanguage()
     * @uses GetPhoneNumberOverviewRequest::setTariffDate()
     * @uses GetPhoneNumberOverviewRequest::setIncludeAI()
     * @param string $phoneNumber
     * @param string $language
     * @param string $tariffDate
     * @param string $includeAI
     */
    public function __construct($phoneNumber = null, $language = null, $tariffDate = null, $includeAI = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setLanguage($language)
            ->setTariffDate($tariffDate)
            ->setIncludeAI($includeAI);
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\GetPhoneNumberOverviewRequest
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($phoneNumber) && !preg_match('/[\\d]{1,}/', $phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\d]{1,}", "%s" given', var_export($phoneNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GetPhoneNumberOverviewRequest
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: length
        if ((is_scalar($language) && strlen($language) !== 2) || (is_array($language) && count($language) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TariffDate value
     * @return string|null
     */
    public function getTariffDate()
    {
        return $this->TariffDate;
    }
    /**
     * Set TariffDate value
     * @param string $tariffDate
     * @return \StructType\GetPhoneNumberOverviewRequest
     */
    public function setTariffDate($tariffDate = null)
    {
        // validation for constraint: string
        if (!is_null($tariffDate) && !is_string($tariffDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffDate)), __LINE__);
        }
        $this->TariffDate = $tariffDate;
        return $this;
    }
    /**
     * Get IncludeAI value
     * @return string|null
     */
    public function getIncludeAI()
    {
        return $this->IncludeAI;
    }
    /**
     * Set IncludeAI value
     * @param string $includeAI
     * @return \StructType\GetPhoneNumberOverviewRequest
     */
    public function setIncludeAI($includeAI = null)
    {
        // validation for constraint: pattern
        if (is_scalar($includeAI) && !preg_match('/[Y|N]/', $includeAI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[Y|N]", "%s" given', var_export($includeAI, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($includeAI) && !is_string($includeAI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includeAI)), __LINE__);
        }
        $this->IncludeAI = $includeAI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPhoneNumberOverviewRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
