<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.tboholidays.com/HotelAPI_V7/HotelService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.tboholidays.com/HotelAPI_V7/HotelService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hotel ServiceType
 */
$hotel = new \ServiceType\Hotel($options);
$hotel->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for HotelSearch operation/method
 */
if ($hotel->HotelSearch(new \StructType\HotelSearchRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCancellationPolicy operation/method
 */
if ($hotel->HotelCancellationPolicy(new \StructType\HotelCancellationPolicyRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCancellationPolicyForAllRooms operation/method
 */
if ($hotel->HotelCancellationPolicyForAllRooms(new \StructType\HotelCancellationPolicyRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelBook operation/method
 */
if ($hotel->HotelBook(new \StructType\HotelBookRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelBookingDetail operation/method
 */
if ($hotel->HotelBookingDetail(new \StructType\HotelBookingDetailRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCancel operation/method
 */
if ($hotel->HotelCancel(new \StructType\HotelCancelRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelDetails operation/method
 */
if ($hotel->HotelDetails(new \StructType\HotelDetailsRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelCodeList operation/method
 */
if ($hotel->HotelCodeList(new \StructType\HotelCodesRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelSearchWithRooms operation/method
 */
if ($hotel->HotelSearchWithRooms(new \StructType\HotelSearchWithRoomsRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Sample call for HotelBookingDetailBasedOnDate operation/method
 */
if ($hotel->HotelBookingDetailBasedOnDate(new \StructType\HotelBookingDetailBasedOnDateRequest()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
/**
 * Samples for Available ServiceType
 */
$available = new \ServiceType\Available($options);
$available->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for AvailableHotelRooms operation/method
 */
if ($available->AvailableHotelRooms(new \StructType\HotelRoomAvailabilityRequest()) !== false) {
    print_r($available->getResult());
} else {
    print_r($available->getLastError());
}
/**
 * Samples for Availability ServiceType
 */
$availability = new \ServiceType\Availability($options);
$availability->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for AvailabilityAndPricing operation/method
 */
if ($availability->AvailabilityAndPricing(new \StructType\AvailabilityAndPricingRequest()) !== false) {
    print_r($availability->getResult());
} else {
    print_r($availability->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
$generate->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for GenerateInvoice operation/method
 */
if ($generate->GenerateInvoice(new \StructType\GenerateInvoiceRequest()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Amendment ServiceType
 */
$amendment = new \ServiceType\Amendment($options);
$amendment->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for Amendment operation/method
 */
if ($amendment->Amendment(new \StructType\AmendmentRequest()) !== false) {
    print_r($amendment->getResult());
} else {
    print_r($amendment->getLastError());
}
/**
 * Samples for Country ServiceType
 */
$country = new \ServiceType\Country($options);
$country->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for CountryList operation/method
 */
if ($country->CountryList(new \StructType\CountryListRequest()) !== false) {
    print_r($country->getResult());
} else {
    print_r($country->getLastError());
}
/**
 * Samples for Destination ServiceType
 */
$destination = new \ServiceType\Destination($options);
$destination->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for DestinationCityList operation/method
 */
if ($destination->DestinationCityList(new \StructType\DestinationCityListRequest()) !== false) {
    print_r($destination->getResult());
} else {
    print_r($destination->getLastError());
}
/**
 * Samples for Top ServiceType
 */
$top = new \ServiceType\Top($options);
$top->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for TopDestinations operation/method
 */
if ($top->TopDestinations(new \StructType\TopDestinationsRequest()) !== false) {
    print_r($top->getResult());
} else {
    print_r($top->getLastError());
}
/**
 * Samples for Giata ServiceType
 */
$giata = new \ServiceType\Giata($options);
$giata->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for GiataHotelCodeList operation/method
 */
if ($giata->GiataHotelCodeList(new \StructType\GiataHotelCodesRequest()) !== false) {
    print_r($giata->getResult());
} else {
    print_r($giata->getLastError());
}
/**
 * Samples for Tag ServiceType
 */
$tag = new \ServiceType\Tag($options);
$tag->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for TagInfo operation/method
 */
if ($tag->TagInfo(new \StructType\TagInfoRequest()) !== false) {
    print_r($tag->getResult());
} else {
    print_r($tag->getLastError());
}
/**
 * Samples for City ServiceType
 */
$city = new \ServiceType\City($options);
$city->setSoapHeaderCredentials($Credentials);
/**
 * Sample call for CityWiseNotification operation/method
 */
if ($city->CityWiseNotification(new \StructType\CityWiseNotificationRequest()) !== false) {
    print_r($city->getResult());
} else {
    print_r($city->getLastError());
}
