<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuppInfo StructType
 * @subpackage Structs
 */
class SuppInfo extends AbstractStructBase
{
    /**
     * The SuppID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SuppID;
    /**
     * The SuppChargeType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SuppChargeType;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Price;
    /**
     * The SuppIsSelected
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $SuppIsSelected;
    /**
     * Constructor method for SuppInfo
     * @uses SuppInfo::setSuppID()
     * @uses SuppInfo::setSuppChargeType()
     * @uses SuppInfo::setPrice()
     * @uses SuppInfo::setSuppIsSelected()
     * @param int $suppID
     * @param string $suppChargeType
     * @param float $price
     * @param bool $suppIsSelected
     */
    public function __construct($suppID = null, $suppChargeType = null, $price = null, $suppIsSelected = null)
    {
        $this
            ->setSuppID($suppID)
            ->setSuppChargeType($suppChargeType)
            ->setPrice($price)
            ->setSuppIsSelected($suppIsSelected);
    }
    /**
     * Get SuppID value
     * @return int
     */
    public function getSuppID()
    {
        return $this->SuppID;
    }
    /**
     * Set SuppID value
     * @param int $suppID
     * @return \StructType\SuppInfo
     */
    public function setSuppID($suppID = null)
    {
        // validation for constraint: int
        if (!is_null($suppID) && !is_numeric($suppID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suppID)), __LINE__);
        }
        $this->SuppID = $suppID;
        return $this;
    }
    /**
     * Get SuppChargeType value
     * @return string
     */
    public function getSuppChargeType()
    {
        return $this->SuppChargeType;
    }
    /**
     * Set SuppChargeType value
     * @uses \EnumType\SuppChargeType::valueIsValid()
     * @uses \EnumType\SuppChargeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suppChargeType
     * @return \StructType\SuppInfo
     */
    public function setSuppChargeType($suppChargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SuppChargeType::valueIsValid($suppChargeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $suppChargeType, implode(', ', \EnumType\SuppChargeType::getValidValues())), __LINE__);
        }
        $this->SuppChargeType = $suppChargeType;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\SuppInfo
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SuppIsSelected value
     * @return bool
     */
    public function getSuppIsSelected()
    {
        return $this->SuppIsSelected;
    }
    /**
     * Set SuppIsSelected value
     * @param bool $suppIsSelected
     * @return \StructType\SuppInfo
     */
    public function setSuppIsSelected($suppIsSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppIsSelected) && !is_bool($suppIsSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppIsSelected)), __LINE__);
        }
        $this->SuppIsSelected = $suppIsSelected;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuppInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
