<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRequest StructType
 * @subpackage Structs
 */
class SpecialRequest extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RequestId;
    /**
     * The RequestType
     * @var string
     */
    public $RequestType;
    /**
     * The Remarks
     * @var string
     */
    public $Remarks;
    /**
     * Constructor method for SpecialRequest
     * @uses SpecialRequest::setRequestId()
     * @uses SpecialRequest::setRequestType()
     * @uses SpecialRequest::setRemarks()
     * @param int $requestId
     * @param string $requestType
     * @param string $remarks
     */
    public function __construct($requestId = null, $requestType = null, $remarks = null)
    {
        $this
            ->setRequestId($requestId)
            ->setRequestType($requestType)
            ->setRemarks($remarks);
    }
    /**
     * Get RequestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param int $requestId
     * @return \StructType\SpecialRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @param string $requestType
     * @return \StructType\SpecialRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\SpecialRequest
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
