<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rooms StructType
 * @subpackage Structs
 */
class Rooms extends AbstractStructBase
{
    /**
     * The RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Inclusion
     * @var string
     */
    public $Inclusion;
    /**
     * Constructor method for Rooms
     * @uses Rooms::setRoomType()
     * @uses Rooms::setRatePlanCode()
     * @uses Rooms::setInclusion()
     * @param string $roomType
     * @param string $ratePlanCode
     * @param string $inclusion
     */
    public function __construct($roomType = null, $ratePlanCode = null, $inclusion = null)
    {
        $this
            ->setRoomType($roomType)
            ->setRatePlanCode($ratePlanCode)
            ->setInclusion($inclusion);
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\Rooms
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\Rooms
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Inclusion value
     * @return string|null
     */
    public function getInclusion()
    {
        return $this->Inclusion;
    }
    /**
     * Set Inclusion value
     * @param string $inclusion
     * @return \StructType\Rooms
     */
    public function setInclusion($inclusion = null)
    {
        // validation for constraint: string
        if (!is_null($inclusion) && !is_string($inclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inclusion)), __LINE__);
        }
        $this->Inclusion = $inclusion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rooms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
