<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomReq StructType
 * @subpackage Structs
 */
class RoomReq extends AbstractStructBase
{
    /**
     * The Amend
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Amend;
    /**
     * The Guest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AmendGuestReq[]
     */
    public $Guest;
    /**
     * Constructor method for RoomReq
     * @uses RoomReq::setAmend()
     * @uses RoomReq::setGuest()
     * @param string $amend
     * @param \StructType\AmendGuestReq[] $guest
     */
    public function __construct($amend = null, array $guest = array())
    {
        $this
            ->setAmend($amend)
            ->setGuest($guest);
    }
    /**
     * Get Amend value
     * @return string
     */
    public function getAmend()
    {
        return $this->Amend;
    }
    /**
     * Set Amend value
     * @uses \EnumType\RoomRequested::valueIsValid()
     * @uses \EnumType\RoomRequested::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amend
     * @return \StructType\RoomReq
     */
    public function setAmend($amend = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoomRequested::valueIsValid($amend)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $amend, implode(', ', \EnumType\RoomRequested::getValidValues())), __LINE__);
        }
        $this->Amend = $amend;
        return $this;
    }
    /**
     * Get Guest value
     * @return \StructType\AmendGuestReq[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\AmendGuestReq[] $guest
     * @return \StructType\RoomReq
     */
    public function setGuest(array $guest = array())
    {
        foreach ($guest as $roomReqGuestItem) {
            // validation for constraint: itemType
            if (!$roomReqGuestItem instanceof \StructType\AmendGuestReq) {
                throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of \StructType\AmendGuestReq, "%s" given', is_object($roomReqGuestItem) ? get_class($roomReqGuestItem) : gettype($roomReqGuestItem)), __LINE__);
            }
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\AmendGuestReq $item
     * @return \StructType\RoomReq
     */
    public function addToGuest(\StructType\AmendGuestReq $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmendGuestReq) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of \StructType\AmendGuestReq, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
