<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomGuest StructType
 * @subpackage Structs
 */
class RoomGuest extends AbstractStructBase
{
    /**
     * The AdultCount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AdultCount;
    /**
     * The ChildCount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ChildCount;
    /**
     * The ChildAge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ChildAge;
    /**
     * Constructor method for RoomGuest
     * @uses RoomGuest::setAdultCount()
     * @uses RoomGuest::setChildCount()
     * @uses RoomGuest::setChildAge()
     * @param int $adultCount
     * @param int $childCount
     * @param \ArrayType\ArrayOfInt $childAge
     */
    public function __construct($adultCount = null, $childCount = null, \ArrayType\ArrayOfInt $childAge = null)
    {
        $this
            ->setAdultCount($adultCount)
            ->setChildCount($childCount)
            ->setChildAge($childAge);
    }
    /**
     * Get AdultCount value
     * @return int
     */
    public function getAdultCount()
    {
        return $this->AdultCount;
    }
    /**
     * Set AdultCount value
     * @param int $adultCount
     * @return \StructType\RoomGuest
     */
    public function setAdultCount($adultCount = null)
    {
        // validation for constraint: int
        if (!is_null($adultCount) && !is_numeric($adultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultCount)), __LINE__);
        }
        $this->AdultCount = $adultCount;
        return $this;
    }
    /**
     * Get ChildCount value
     * @return int
     */
    public function getChildCount()
    {
        return $this->ChildCount;
    }
    /**
     * Set ChildCount value
     * @param int $childCount
     * @return \StructType\RoomGuest
     */
    public function setChildCount($childCount = null)
    {
        // validation for constraint: int
        if (!is_null($childCount) && !is_numeric($childCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childCount)), __LINE__);
        }
        $this->ChildCount = $childCount;
        return $this;
    }
    /**
     * Get ChildAge value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getChildAge()
    {
        return $this->ChildAge;
    }
    /**
     * Set ChildAge value
     * @param \ArrayType\ArrayOfInt $childAge
     * @return \StructType\RoomGuest
     */
    public function setChildAge(\ArrayType\ArrayOfInt $childAge = null)
    {
        $this->ChildAge = $childAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
