<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomCombination StructType
 * @subpackage Structs
 */
class RoomCombination extends AbstractStructBase
{
    /**
     * The RoomIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $RoomIndex;
    /**
     * The TestElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestElement;
    /**
     * Constructor method for RoomCombination
     * @uses RoomCombination::setRoomIndex()
     * @uses RoomCombination::setTestElement()
     * @param int[] $roomIndex
     * @param string $testElement
     */
    public function __construct(array $roomIndex = array(), $testElement = null)
    {
        $this
            ->setRoomIndex($roomIndex)
            ->setTestElement($testElement);
    }
    /**
     * Get RoomIndex value
     * @return int[]|null
     */
    public function getRoomIndex()
    {
        return $this->RoomIndex;
    }
    /**
     * Set RoomIndex value
     * @throws \InvalidArgumentException
     * @param int[] $roomIndex
     * @return \StructType\RoomCombination
     */
    public function setRoomIndex(array $roomIndex = array())
    {
        foreach ($roomIndex as $roomCombinationRoomIndexItem) {
            // validation for constraint: itemType
            if (!is_numeric($roomCombinationRoomIndexItem)) {
                throw new \InvalidArgumentException(sprintf('The RoomIndex property can only contain items of int, "%s" given', is_object($roomCombinationRoomIndexItem) ? get_class($roomCombinationRoomIndexItem) : gettype($roomCombinationRoomIndexItem)), __LINE__);
            }
        }
        $this->RoomIndex = $roomIndex;
        return $this;
    }
    /**
     * Add item to RoomIndex value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\RoomCombination
     */
    public function addToRoomIndex($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The RoomIndex property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomIndex[] = $item;
        return $this;
    }
    /**
     * Get TestElement value
     * @return string|null
     */
    public function getTestElement()
    {
        return $this->TestElement;
    }
    /**
     * Set TestElement value
     * @param string $testElement
     * @return \StructType\RoomCombination
     */
    public function setTestElement($testElement = null)
    {
        // validation for constraint: string
        if (!is_null($testElement) && !is_string($testElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testElement)), __LINE__);
        }
        $this->TestElement = $testElement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomCombination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
