<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceVerification StructType
 * @subpackage Structs
 */
class PriceVerification extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The PriceChanged
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PriceChanged;
    /**
     * The AvailableOnNewPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AvailableOnNewPrice;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel_Room
     */
    public $HotelRooms;
    /**
     * Constructor method for PriceVerification
     * @uses PriceVerification::setStatus()
     * @uses PriceVerification::setPriceChanged()
     * @uses PriceVerification::setAvailableOnNewPrice()
     * @uses PriceVerification::setHotelRooms()
     * @param string $status
     * @param bool $priceChanged
     * @param bool $availableOnNewPrice
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     */
    public function __construct($status = null, $priceChanged = null, $availableOnNewPrice = null, \ArrayType\ArrayOfHotel_Room $hotelRooms = null)
    {
        $this
            ->setStatus($status)
            ->setPriceChanged($priceChanged)
            ->setAvailableOnNewPrice($availableOnNewPrice)
            ->setHotelRooms($hotelRooms);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\PriceVerificationStatus::valueIsValid()
     * @uses \EnumType\PriceVerificationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PriceVerification
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceVerificationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\PriceVerificationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PriceChanged value
     * @return bool
     */
    public function getPriceChanged()
    {
        return $this->PriceChanged;
    }
    /**
     * Set PriceChanged value
     * @param bool $priceChanged
     * @return \StructType\PriceVerification
     */
    public function setPriceChanged($priceChanged = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceChanged) && !is_bool($priceChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceChanged)), __LINE__);
        }
        $this->PriceChanged = $priceChanged;
        return $this;
    }
    /**
     * Get AvailableOnNewPrice value
     * @return bool
     */
    public function getAvailableOnNewPrice()
    {
        return $this->AvailableOnNewPrice;
    }
    /**
     * Set AvailableOnNewPrice value
     * @param bool $availableOnNewPrice
     * @return \StructType\PriceVerification
     */
    public function setAvailableOnNewPrice($availableOnNewPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnNewPrice) && !is_bool($availableOnNewPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnNewPrice)), __LINE__);
        }
        $this->AvailableOnNewPrice = $availableOnNewPrice;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfHotel_Room|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @return \StructType\PriceVerification
     */
    public function setHotelRooms(\ArrayType\ArrayOfHotel_Room $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceVerification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
