<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinHotelPrice StructType
 * @subpackage Structs
 */
class MinHotelPrice extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalPrice;
    /**
     * The B2CRates
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $B2CRates;
    /**
     * The OriginalPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $OriginalPrice;
    /**
     * The PrefPrice
     * @var string
     */
    public $PrefPrice;
    /**
     * The PrefCurrency
     * @var string
     */
    public $PrefCurrency;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for MinHotelPrice
     * @uses MinHotelPrice::setTotalPrice()
     * @uses MinHotelPrice::setB2CRates()
     * @uses MinHotelPrice::setOriginalPrice()
     * @uses MinHotelPrice::setPrefPrice()
     * @uses MinHotelPrice::setPrefCurrency()
     * @uses MinHotelPrice::setCurrency()
     * @param float $totalPrice
     * @param bool $b2CRates
     * @param float $originalPrice
     * @param string $prefPrice
     * @param string $prefCurrency
     * @param string $currency
     */
    public function __construct($totalPrice = null, $b2CRates = null, $originalPrice = null, $prefPrice = null, $prefCurrency = null, $currency = null)
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setB2CRates($b2CRates)
            ->setOriginalPrice($originalPrice)
            ->setPrefPrice($prefPrice)
            ->setPrefCurrency($prefCurrency)
            ->setCurrency($currency);
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\MinHotelPrice
     */
    public function setTotalPrice($totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get B2CRates value
     * @return bool
     */
    public function getB2CRates()
    {
        return $this->B2CRates;
    }
    /**
     * Set B2CRates value
     * @param bool $b2CRates
     * @return \StructType\MinHotelPrice
     */
    public function setB2CRates($b2CRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($b2CRates) && !is_bool($b2CRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($b2CRates)), __LINE__);
        }
        $this->B2CRates = $b2CRates;
        return $this;
    }
    /**
     * Get OriginalPrice value
     * @return float
     */
    public function getOriginalPrice()
    {
        return $this->OriginalPrice;
    }
    /**
     * Set OriginalPrice value
     * @param float $originalPrice
     * @return \StructType\MinHotelPrice
     */
    public function setOriginalPrice($originalPrice = null)
    {
        $this->OriginalPrice = $originalPrice;
        return $this;
    }
    /**
     * Get PrefPrice value
     * @return string|null
     */
    public function getPrefPrice()
    {
        return $this->PrefPrice;
    }
    /**
     * Set PrefPrice value
     * @param string $prefPrice
     * @return \StructType\MinHotelPrice
     */
    public function setPrefPrice($prefPrice = null)
    {
        // validation for constraint: string
        if (!is_null($prefPrice) && !is_string($prefPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefPrice)), __LINE__);
        }
        $this->PrefPrice = $prefPrice;
        return $this;
    }
    /**
     * Get PrefCurrency value
     * @return string|null
     */
    public function getPrefCurrency()
    {
        return $this->PrefCurrency;
    }
    /**
     * Set PrefCurrency value
     * @param string $prefCurrency
     * @return \StructType\MinHotelPrice
     */
    public function setPrefCurrency($prefCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($prefCurrency) && !is_string($prefCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefCurrency)), __LINE__);
        }
        $this->PrefCurrency = $prefCurrency;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\MinHotelPrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MinHotelPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
