<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_ResultWithRooms StructType
 * @subpackage Structs
 */
class Hotel_ResultWithRooms extends AbstractStructBase
{
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The MoreRoomsAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MoreRoomsAvailable;
    /**
     * The IsPkgProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPkgProperty;
    /**
     * The IsPackageRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPackageRate;
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelInfo
     */
    public $HotelInfo;
    /**
     * The MinHotelPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MinHotelPrice
     */
    public $MinHotelPrice;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel_Room
     */
    public $HotelRooms;
    /**
     * The OptionsForBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingOptions
     */
    public $OptionsForBooking;
    /**
     * Constructor method for Hotel_ResultWithRooms
     * @uses Hotel_ResultWithRooms::setResultIndex()
     * @uses Hotel_ResultWithRooms::setMoreRoomsAvailable()
     * @uses Hotel_ResultWithRooms::setIsPkgProperty()
     * @uses Hotel_ResultWithRooms::setIsPackageRate()
     * @uses Hotel_ResultWithRooms::setHotelInfo()
     * @uses Hotel_ResultWithRooms::setMinHotelPrice()
     * @uses Hotel_ResultWithRooms::setHotelRooms()
     * @uses Hotel_ResultWithRooms::setOptionsForBooking()
     * @param int $resultIndex
     * @param bool $moreRoomsAvailable
     * @param bool $isPkgProperty
     * @param bool $isPackageRate
     * @param \StructType\HotelInfo $hotelInfo
     * @param \StructType\MinHotelPrice $minHotelPrice
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @param \StructType\BookingOptions $optionsForBooking
     */
    public function __construct($resultIndex = null, $moreRoomsAvailable = null, $isPkgProperty = null, $isPackageRate = null, \StructType\HotelInfo $hotelInfo = null, \StructType\MinHotelPrice $minHotelPrice = null, \ArrayType\ArrayOfHotel_Room $hotelRooms = null, \StructType\BookingOptions $optionsForBooking = null)
    {
        $this
            ->setResultIndex($resultIndex)
            ->setMoreRoomsAvailable($moreRoomsAvailable)
            ->setIsPkgProperty($isPkgProperty)
            ->setIsPackageRate($isPackageRate)
            ->setHotelInfo($hotelInfo)
            ->setMinHotelPrice($minHotelPrice)
            ->setHotelRooms($hotelRooms)
            ->setOptionsForBooking($optionsForBooking);
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get MoreRoomsAvailable value
     * @return bool
     */
    public function getMoreRoomsAvailable()
    {
        return $this->MoreRoomsAvailable;
    }
    /**
     * Set MoreRoomsAvailable value
     * @param bool $moreRoomsAvailable
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setMoreRoomsAvailable($moreRoomsAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreRoomsAvailable) && !is_bool($moreRoomsAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreRoomsAvailable)), __LINE__);
        }
        $this->MoreRoomsAvailable = $moreRoomsAvailable;
        return $this;
    }
    /**
     * Get IsPkgProperty value
     * @return bool
     */
    public function getIsPkgProperty()
    {
        return $this->IsPkgProperty;
    }
    /**
     * Set IsPkgProperty value
     * @param bool $isPkgProperty
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setIsPkgProperty($isPkgProperty = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPkgProperty) && !is_bool($isPkgProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPkgProperty)), __LINE__);
        }
        $this->IsPkgProperty = $isPkgProperty;
        return $this;
    }
    /**
     * Get IsPackageRate value
     * @return bool
     */
    public function getIsPackageRate()
    {
        return $this->IsPackageRate;
    }
    /**
     * Set IsPackageRate value
     * @param bool $isPackageRate
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setIsPackageRate($isPackageRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPackageRate) && !is_bool($isPackageRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPackageRate)), __LINE__);
        }
        $this->IsPackageRate = $isPackageRate;
        return $this;
    }
    /**
     * Get HotelInfo value
     * @return \StructType\HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\HotelInfo $hotelInfo
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setHotelInfo(\StructType\HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get MinHotelPrice value
     * @return \StructType\MinHotelPrice|null
     */
    public function getMinHotelPrice()
    {
        return $this->MinHotelPrice;
    }
    /**
     * Set MinHotelPrice value
     * @param \StructType\MinHotelPrice $minHotelPrice
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setMinHotelPrice(\StructType\MinHotelPrice $minHotelPrice = null)
    {
        $this->MinHotelPrice = $minHotelPrice;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfHotel_Room|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setHotelRooms(\ArrayType\ArrayOfHotel_Room $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get OptionsForBooking value
     * @return \StructType\BookingOptions|null
     */
    public function getOptionsForBooking()
    {
        return $this->OptionsForBooking;
    }
    /**
     * Set OptionsForBooking value
     * @param \StructType\BookingOptions $optionsForBooking
     * @return \StructType\Hotel_ResultWithRooms
     */
    public function setOptionsForBooking(\StructType\BookingOptions $optionsForBooking = null)
    {
        $this->OptionsForBooking = $optionsForBooking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Hotel_ResultWithRooms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
