<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchWithRoomsRequest StructType
 * @subpackage Structs
 */
class HotelSearchWithRoomsRequest extends AbstractStructBase
{
    /**
     * The CheckInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckOutDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckOutDate;
    /**
     * The CityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CityId;
    /**
     * The IsNearBySearchAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNearBySearchAllowed;
    /**
     * The NoOfRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoOfRooms;
    /**
     * The ResultCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCount;
    /**
     * The ResponseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponseTime;
    /**
     * The IsCancellationPolicyRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCancellationPolicyRequired;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The GuestNationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuestNationality;
    /**
     * The RoomGuests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoomGuest
     */
    public $RoomGuests;
    /**
     * The PreferredCurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreferredCurrencyCode;
    /**
     * The Filters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelSearchWithRoomsFilters
     */
    public $Filters;
    /**
     * Constructor method for HotelSearchWithRoomsRequest
     * @uses HotelSearchWithRoomsRequest::setCheckInDate()
     * @uses HotelSearchWithRoomsRequest::setCheckOutDate()
     * @uses HotelSearchWithRoomsRequest::setCityId()
     * @uses HotelSearchWithRoomsRequest::setIsNearBySearchAllowed()
     * @uses HotelSearchWithRoomsRequest::setNoOfRooms()
     * @uses HotelSearchWithRoomsRequest::setResultCount()
     * @uses HotelSearchWithRoomsRequest::setResponseTime()
     * @uses HotelSearchWithRoomsRequest::setIsCancellationPolicyRequired()
     * @uses HotelSearchWithRoomsRequest::setCountryName()
     * @uses HotelSearchWithRoomsRequest::setCityName()
     * @uses HotelSearchWithRoomsRequest::setGuestNationality()
     * @uses HotelSearchWithRoomsRequest::setRoomGuests()
     * @uses HotelSearchWithRoomsRequest::setPreferredCurrencyCode()
     * @uses HotelSearchWithRoomsRequest::setFilters()
     * @param string $checkInDate
     * @param string $checkOutDate
     * @param int $cityId
     * @param bool $isNearBySearchAllowed
     * @param int $noOfRooms
     * @param int $resultCount
     * @param int $responseTime
     * @param bool $isCancellationPolicyRequired
     * @param string $countryName
     * @param string $cityName
     * @param string $guestNationality
     * @param \ArrayType\ArrayOfRoomGuest $roomGuests
     * @param string $preferredCurrencyCode
     * @param \StructType\HotelSearchWithRoomsFilters $filters
     */
    public function __construct($checkInDate = null, $checkOutDate = null, $cityId = null, $isNearBySearchAllowed = null, $noOfRooms = null, $resultCount = null, $responseTime = null, $isCancellationPolicyRequired = null, $countryName = null, $cityName = null, $guestNationality = null, \ArrayType\ArrayOfRoomGuest $roomGuests = null, $preferredCurrencyCode = null, \StructType\HotelSearchWithRoomsFilters $filters = null)
    {
        $this
            ->setCheckInDate($checkInDate)
            ->setCheckOutDate($checkOutDate)
            ->setCityId($cityId)
            ->setIsNearBySearchAllowed($isNearBySearchAllowed)
            ->setNoOfRooms($noOfRooms)
            ->setResultCount($resultCount)
            ->setResponseTime($responseTime)
            ->setIsCancellationPolicyRequired($isCancellationPolicyRequired)
            ->setCountryName($countryName)
            ->setCityName($cityName)
            ->setGuestNationality($guestNationality)
            ->setRoomGuests($roomGuests)
            ->setPreferredCurrencyCode($preferredCurrencyCode)
            ->setFilters($filters);
    }
    /**
     * Get CheckInDate value
     * @return string
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CheckOutDate value
     * @return string
     */
    public function getCheckOutDate()
    {
        return $this->CheckOutDate;
    }
    /**
     * Set CheckOutDate value
     * @param string $checkOutDate
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setCheckOutDate($checkOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutDate) && !is_string($checkOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOutDate)), __LINE__);
        }
        $this->CheckOutDate = $checkOutDate;
        return $this;
    }
    /**
     * Get CityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->CityId;
    }
    /**
     * Set CityId value
     * @param int $cityId
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !is_numeric($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cityId)), __LINE__);
        }
        $this->CityId = $cityId;
        return $this;
    }
    /**
     * Get IsNearBySearchAllowed value
     * @return bool
     */
    public function getIsNearBySearchAllowed()
    {
        return $this->IsNearBySearchAllowed;
    }
    /**
     * Set IsNearBySearchAllowed value
     * @param bool $isNearBySearchAllowed
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setIsNearBySearchAllowed($isNearBySearchAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNearBySearchAllowed) && !is_bool($isNearBySearchAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNearBySearchAllowed)), __LINE__);
        }
        $this->IsNearBySearchAllowed = $isNearBySearchAllowed;
        return $this;
    }
    /**
     * Get NoOfRooms value
     * @return int
     */
    public function getNoOfRooms()
    {
        return $this->NoOfRooms;
    }
    /**
     * Set NoOfRooms value
     * @param int $noOfRooms
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setNoOfRooms($noOfRooms = null)
    {
        // validation for constraint: int
        if (!is_null($noOfRooms) && !is_numeric($noOfRooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfRooms)), __LINE__);
        }
        $this->NoOfRooms = $noOfRooms;
        return $this;
    }
    /**
     * Get ResultCount value
     * @return int
     */
    public function getResultCount()
    {
        return $this->ResultCount;
    }
    /**
     * Set ResultCount value
     * @param int $resultCount
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setResultCount($resultCount = null)
    {
        // validation for constraint: int
        if (!is_null($resultCount) && !is_numeric($resultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCount)), __LINE__);
        }
        $this->ResultCount = $resultCount;
        return $this;
    }
    /**
     * Get ResponseTime value
     * @return int
     */
    public function getResponseTime()
    {
        return $this->ResponseTime;
    }
    /**
     * Set ResponseTime value
     * @param int $responseTime
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setResponseTime($responseTime = null)
    {
        // validation for constraint: int
        if (!is_null($responseTime) && !is_numeric($responseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseTime)), __LINE__);
        }
        $this->ResponseTime = $responseTime;
        return $this;
    }
    /**
     * Get IsCancellationPolicyRequired value
     * @return bool
     */
    public function getIsCancellationPolicyRequired()
    {
        return $this->IsCancellationPolicyRequired;
    }
    /**
     * Set IsCancellationPolicyRequired value
     * @param bool $isCancellationPolicyRequired
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setIsCancellationPolicyRequired($isCancellationPolicyRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCancellationPolicyRequired) && !is_bool($isCancellationPolicyRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCancellationPolicyRequired)), __LINE__);
        }
        $this->IsCancellationPolicyRequired = $isCancellationPolicyRequired;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get GuestNationality value
     * @return string|null
     */
    public function getGuestNationality()
    {
        return $this->GuestNationality;
    }
    /**
     * Set GuestNationality value
     * @param string $guestNationality
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setGuestNationality($guestNationality = null)
    {
        // validation for constraint: string
        if (!is_null($guestNationality) && !is_string($guestNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestNationality)), __LINE__);
        }
        $this->GuestNationality = $guestNationality;
        return $this;
    }
    /**
     * Get RoomGuests value
     * @return \ArrayType\ArrayOfRoomGuest|null
     */
    public function getRoomGuests()
    {
        return $this->RoomGuests;
    }
    /**
     * Set RoomGuests value
     * @param \ArrayType\ArrayOfRoomGuest $roomGuests
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setRoomGuests(\ArrayType\ArrayOfRoomGuest $roomGuests = null)
    {
        $this->RoomGuests = $roomGuests;
        return $this;
    }
    /**
     * Get PreferredCurrencyCode value
     * @return string|null
     */
    public function getPreferredCurrencyCode()
    {
        return $this->PreferredCurrencyCode;
    }
    /**
     * Set PreferredCurrencyCode value
     * @param string $preferredCurrencyCode
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setPreferredCurrencyCode($preferredCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCurrencyCode) && !is_string($preferredCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredCurrencyCode)), __LINE__);
        }
        $this->PreferredCurrencyCode = $preferredCurrencyCode;
        return $this;
    }
    /**
     * Get Filters value
     * @return \StructType\HotelSearchWithRoomsFilters|null
     */
    public function getFilters()
    {
        return $this->Filters;
    }
    /**
     * Set Filters value
     * @param \StructType\HotelSearchWithRoomsFilters $filters
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public function setFilters(\StructType\HotelSearchWithRoomsFilters $filters = null)
    {
        $this->Filters = $filters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelSearchWithRoomsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
