<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomAvailabilityResponse StructType
 * @subpackage Structs
 */
class HotelRoomAvailabilityResponse extends AbstractStructBase
{
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotel_Room
     */
    public $HotelRooms;
    /**
     * The OptionsForBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingOptions
     */
    public $OptionsForBooking;
    /**
     * Constructor method for HotelRoomAvailabilityResponse
     * @uses HotelRoomAvailabilityResponse::setResultIndex()
     * @uses HotelRoomAvailabilityResponse::setStatus()
     * @uses HotelRoomAvailabilityResponse::setHotelRooms()
     * @uses HotelRoomAvailabilityResponse::setOptionsForBooking()
     * @param int $resultIndex
     * @param \StructType\ResponseStatus $status
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @param \StructType\BookingOptions $optionsForBooking
     */
    public function __construct($resultIndex = null, \StructType\ResponseStatus $status = null, \ArrayType\ArrayOfHotel_Room $hotelRooms = null, \StructType\BookingOptions $optionsForBooking = null)
    {
        $this
            ->setResultIndex($resultIndex)
            ->setStatus($status)
            ->setHotelRooms($hotelRooms)
            ->setOptionsForBooking($optionsForBooking);
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\HotelRoomAvailabilityResponse
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\HotelRoomAvailabilityResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfHotel_Room|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfHotel_Room $hotelRooms
     * @return \StructType\HotelRoomAvailabilityResponse
     */
    public function setHotelRooms(\ArrayType\ArrayOfHotel_Room $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get OptionsForBooking value
     * @return \StructType\BookingOptions|null
     */
    public function getOptionsForBooking()
    {
        return $this->OptionsForBooking;
    }
    /**
     * Set OptionsForBooking value
     * @param \StructType\BookingOptions $optionsForBooking
     * @return \StructType\HotelRoomAvailabilityResponse
     */
    public function setOptionsForBooking(\StructType\BookingOptions $optionsForBooking = null)
    {
        $this->OptionsForBooking = $optionsForBooking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomAvailabilityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
