<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelCancelResponse StructType
 * @subpackage Structs
 */
class HotelCancelResponse extends AbstractStructBase
{
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The CancellationCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CancellationCharge;
    /**
     * The RefundAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RefundAmount;
    /**
     * The RequestStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestStatus;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * Constructor method for HotelCancelResponse
     * @uses HotelCancelResponse::setBookingId()
     * @uses HotelCancelResponse::setCancellationCharge()
     * @uses HotelCancelResponse::setRefundAmount()
     * @uses HotelCancelResponse::setRequestStatus()
     * @uses HotelCancelResponse::setStatus()
     * @param int $bookingId
     * @param float $cancellationCharge
     * @param float $refundAmount
     * @param string $requestStatus
     * @param \StructType\ResponseStatus $status
     */
    public function __construct($bookingId = null, $cancellationCharge = null, $refundAmount = null, $requestStatus = null, \StructType\ResponseStatus $status = null)
    {
        $this
            ->setBookingId($bookingId)
            ->setCancellationCharge($cancellationCharge)
            ->setRefundAmount($refundAmount)
            ->setRequestStatus($requestStatus)
            ->setStatus($status);
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\HotelCancelResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get CancellationCharge value
     * @return float
     */
    public function getCancellationCharge()
    {
        return $this->CancellationCharge;
    }
    /**
     * Set CancellationCharge value
     * @param float $cancellationCharge
     * @return \StructType\HotelCancelResponse
     */
    public function setCancellationCharge($cancellationCharge = null)
    {
        $this->CancellationCharge = $cancellationCharge;
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return float
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param float $refundAmount
     * @return \StructType\HotelCancelResponse
     */
    public function setRefundAmount($refundAmount = null)
    {
        $this->RefundAmount = $refundAmount;
        return $this;
    }
    /**
     * Get RequestStatus value
     * @return string
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @uses \EnumType\HotelCancelStatus::valueIsValid()
     * @uses \EnumType\HotelCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestStatus
     * @return \StructType\HotelCancelResponse
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotelCancelStatus::valueIsValid($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestStatus, implode(', ', \EnumType\HotelCancelStatus::getValidValues())), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\HotelCancelResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelCancelResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
