<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelCancelRequest StructType
 * @subpackage Structs
 */
class HotelCancelRequest extends AbstractStructBase
{
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestType;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The ConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNo;
    /**
     * Constructor method for HotelCancelRequest
     * @uses HotelCancelRequest::setBookingId()
     * @uses HotelCancelRequest::setRequestType()
     * @uses HotelCancelRequest::setRemarks()
     * @uses HotelCancelRequest::setConfirmationNo()
     * @param int $bookingId
     * @param string $requestType
     * @param string $remarks
     * @param string $confirmationNo
     */
    public function __construct($bookingId = null, $requestType = null, $remarks = null, $confirmationNo = null)
    {
        $this
            ->setBookingId($bookingId)
            ->setRequestType($requestType)
            ->setRemarks($remarks)
            ->setConfirmationNo($confirmationNo);
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\HotelCancelRequest
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \EnumType\CancelRequestType::valueIsValid()
     * @uses \EnumType\CancelRequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\HotelCancelRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CancelRequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\CancelRequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\HotelCancelRequest
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\HotelCancelRequest
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelCancelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
