<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelBookResponse StructType
 * @subpackage Structs
 */
class HotelBookResponse extends AbstractStructBase
{
    /**
     * The BookingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BookingStatus;
    /**
     * The BookingId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BookingId;
    /**
     * The TripId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TripId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The ConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNo;
    /**
     * The SupplierReferenceNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierReferenceNo;
    /**
     * The PriceChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceChangeStatus
     */
    public $PriceChange;
    /**
     * The SupplierConfirmationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierConfirmationNo;
    /**
     * Constructor method for HotelBookResponse
     * @uses HotelBookResponse::setBookingStatus()
     * @uses HotelBookResponse::setBookingId()
     * @uses HotelBookResponse::setTripId()
     * @uses HotelBookResponse::setStatus()
     * @uses HotelBookResponse::setConfirmationNo()
     * @uses HotelBookResponse::setSupplierReferenceNo()
     * @uses HotelBookResponse::setPriceChange()
     * @uses HotelBookResponse::setSupplierConfirmationNo()
     * @param string $bookingStatus
     * @param int $bookingId
     * @param int $tripId
     * @param \StructType\ResponseStatus $status
     * @param string $confirmationNo
     * @param string $supplierReferenceNo
     * @param \StructType\PriceChangeStatus $priceChange
     * @param string $supplierConfirmationNo
     */
    public function __construct($bookingStatus = null, $bookingId = null, $tripId = null, \StructType\ResponseStatus $status = null, $confirmationNo = null, $supplierReferenceNo = null, \StructType\PriceChangeStatus $priceChange = null, $supplierConfirmationNo = null)
    {
        $this
            ->setBookingStatus($bookingStatus)
            ->setBookingId($bookingId)
            ->setTripId($tripId)
            ->setStatus($status)
            ->setConfirmationNo($confirmationNo)
            ->setSupplierReferenceNo($supplierReferenceNo)
            ->setPriceChange($priceChange)
            ->setSupplierConfirmationNo($supplierConfirmationNo);
    }
    /**
     * Get BookingStatus value
     * @return string
     */
    public function getBookingStatus()
    {
        return $this->BookingStatus;
    }
    /**
     * Set BookingStatus value
     * @uses \EnumType\APIHotelBookingStatus::valueIsValid()
     * @uses \EnumType\APIHotelBookingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatus
     * @return \StructType\HotelBookResponse
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\APIHotelBookingStatus::valueIsValid($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bookingStatus, implode(', ', \EnumType\APIHotelBookingStatus::getValidValues())), __LINE__);
        }
        $this->BookingStatus = $bookingStatus;
        return $this;
    }
    /**
     * Get BookingId value
     * @return int
     */
    public function getBookingId()
    {
        return $this->BookingId;
    }
    /**
     * Set BookingId value
     * @param int $bookingId
     * @return \StructType\HotelBookResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: int
        if (!is_null($bookingId) && !is_numeric($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bookingId)), __LINE__);
        }
        $this->BookingId = $bookingId;
        return $this;
    }
    /**
     * Get TripId value
     * @return int
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param int $tripId
     * @return \StructType\HotelBookResponse
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: int
        if (!is_null($tripId) && !is_numeric($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\HotelBookResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ConfirmationNo value
     * @return string|null
     */
    public function getConfirmationNo()
    {
        return $this->ConfirmationNo;
    }
    /**
     * Set ConfirmationNo value
     * @param string $confirmationNo
     * @return \StructType\HotelBookResponse
     */
    public function setConfirmationNo($confirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNo) && !is_string($confirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmationNo)), __LINE__);
        }
        $this->ConfirmationNo = $confirmationNo;
        return $this;
    }
    /**
     * Get SupplierReferenceNo value
     * @return string|null
     */
    public function getSupplierReferenceNo()
    {
        return $this->SupplierReferenceNo;
    }
    /**
     * Set SupplierReferenceNo value
     * @param string $supplierReferenceNo
     * @return \StructType\HotelBookResponse
     */
    public function setSupplierReferenceNo($supplierReferenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceNo) && !is_string($supplierReferenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierReferenceNo)), __LINE__);
        }
        $this->SupplierReferenceNo = $supplierReferenceNo;
        return $this;
    }
    /**
     * Get PriceChange value
     * @return \StructType\PriceChangeStatus|null
     */
    public function getPriceChange()
    {
        return $this->PriceChange;
    }
    /**
     * Set PriceChange value
     * @param \StructType\PriceChangeStatus $priceChange
     * @return \StructType\HotelBookResponse
     */
    public function setPriceChange(\StructType\PriceChangeStatus $priceChange = null)
    {
        $this->PriceChange = $priceChange;
        return $this;
    }
    /**
     * Get SupplierConfirmationNo value
     * @return string|null
     */
    public function getSupplierConfirmationNo()
    {
        return $this->SupplierConfirmationNo;
    }
    /**
     * Set SupplierConfirmationNo value
     * @param string $supplierConfirmationNo
     * @return \StructType\HotelBookResponse
     */
    public function setSupplierConfirmationNo($supplierConfirmationNo = null)
    {
        // validation for constraint: string
        if (!is_null($supplierConfirmationNo) && !is_string($supplierConfirmationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierConfirmationNo)), __LINE__);
        }
        $this->SupplierConfirmationNo = $supplierConfirmationNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelBookResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
