<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiataHotelCodesRequest StructType
 * @subpackage Structs
 */
class GiataHotelCodesRequest extends AbstractStructBase
{
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityCode;
    /**
     * The IsDetailedResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsDetailedResponse;
    /**
     * Constructor method for GiataHotelCodesRequest
     * @uses GiataHotelCodesRequest::setCityCode()
     * @uses GiataHotelCodesRequest::setIsDetailedResponse()
     * @param string $cityCode
     * @param string $isDetailedResponse
     */
    public function __construct($cityCode = null, $isDetailedResponse = null)
    {
        $this
            ->setCityCode($cityCode)
            ->setIsDetailedResponse($isDetailedResponse);
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \StructType\GiataHotelCodesRequest
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get IsDetailedResponse value
     * @return string|null
     */
    public function getIsDetailedResponse()
    {
        return $this->IsDetailedResponse;
    }
    /**
     * Set IsDetailedResponse value
     * @param string $isDetailedResponse
     * @return \StructType\GiataHotelCodesRequest
     */
    public function setIsDetailedResponse($isDetailedResponse = null)
    {
        // validation for constraint: string
        if (!is_null($isDetailedResponse) && !is_string($isDetailedResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDetailedResponse)), __LINE__);
        }
        $this->IsDetailedResponse = $isDetailedResponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GiataHotelCodesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
