<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationCityListResponse StructType
 * @subpackage Structs
 */
class DestinationCityListResponse extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CityList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCityList
     */
    public $CityList;
    /**
     * Constructor method for DestinationCityListResponse
     * @uses DestinationCityListResponse::setStatus()
     * @uses DestinationCityListResponse::setCountryName()
     * @uses DestinationCityListResponse::setCityList()
     * @param \StructType\ResponseStatus $status
     * @param string $countryName
     * @param \ArrayType\ArrayOfCityList $cityList
     */
    public function __construct(\StructType\ResponseStatus $status = null, $countryName = null, \ArrayType\ArrayOfCityList $cityList = null)
    {
        $this
            ->setStatus($status)
            ->setCountryName($countryName)
            ->setCityList($cityList);
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\DestinationCityListResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\DestinationCityListResponse
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CityList value
     * @return \ArrayType\ArrayOfCityList|null
     */
    public function getCityList()
    {
        return $this->CityList;
    }
    /**
     * Set CityList value
     * @param \ArrayType\ArrayOfCityList $cityList
     * @return \StructType\DestinationCityListResponse
     */
    public function setCityList(\ArrayType\ArrayOfCityList $cityList = null)
    {
        $this->CityList = $cityList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationCityListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
