<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DayRate StructType
 * @subpackage Structs
 */
class DayRate extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Date;
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $BaseFare;
    /**
     * Constructor method for DayRate
     * @uses DayRate::setDate()
     * @uses DayRate::setBaseFare()
     * @param string $date
     * @param float $baseFare
     */
    public function __construct($date = null, $baseFare = null)
    {
        $this
            ->setDate($date)
            ->setBaseFare($baseFare);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\DayRate
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return float
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param float $baseFare
     * @return \StructType\DayRate
     */
    public function setBaseFare($baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DayRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
