<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckOutRes StructType
 * @subpackage Structs
 */
class CheckOutRes extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Date;
    /**
     * The DateAction
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DateAction;
    /**
     * Constructor method for CheckOutRes
     * @uses CheckOutRes::setDate()
     * @uses CheckOutRes::setDateAction()
     * @param string $date
     * @param string $dateAction
     */
    public function __construct($date = null, $dateAction = null)
    {
        $this
            ->setDate($date)
            ->setDateAction($dateAction);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\CheckOutRes
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get DateAction value
     * @return string
     */
    public function getDateAction()
    {
        return $this->DateAction;
    }
    /**
     * Set DateAction value
     * @uses \EnumType\DateActionRes::valueIsValid()
     * @uses \EnumType\DateActionRes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateAction
     * @return \StructType\CheckOutRes
     */
    public function setDateAction($dateAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DateActionRes::valueIsValid($dateAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateAction, implode(', ', \EnumType\DateActionRes::getValidValues())), __LINE__);
        }
        $this->DateAction = $dateAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckOutRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
