<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingOptions StructType
 * @subpackage Structs
 */
class BookingOptions extends AbstractStructBase
{
    /**
     * The FixedFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FixedFormat;
    /**
     * The RoomCombination
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomCombination[]
     */
    public $RoomCombination;
    /**
     * Constructor method for BookingOptions
     * @uses BookingOptions::setFixedFormat()
     * @uses BookingOptions::setRoomCombination()
     * @param bool $fixedFormat
     * @param \StructType\RoomCombination[] $roomCombination
     */
    public function __construct($fixedFormat = null, array $roomCombination = array())
    {
        $this
            ->setFixedFormat($fixedFormat)
            ->setRoomCombination($roomCombination);
    }
    /**
     * Get FixedFormat value
     * @return bool
     */
    public function getFixedFormat()
    {
        return $this->FixedFormat;
    }
    /**
     * Set FixedFormat value
     * @param bool $fixedFormat
     * @return \StructType\BookingOptions
     */
    public function setFixedFormat($fixedFormat = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedFormat) && !is_bool($fixedFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fixedFormat)), __LINE__);
        }
        $this->FixedFormat = $fixedFormat;
        return $this;
    }
    /**
     * Get RoomCombination value
     * @return \StructType\RoomCombination[]|null
     */
    public function getRoomCombination()
    {
        return $this->RoomCombination;
    }
    /**
     * Set RoomCombination value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCombination[] $roomCombination
     * @return \StructType\BookingOptions
     */
    public function setRoomCombination(array $roomCombination = array())
    {
        foreach ($roomCombination as $bookingOptionsRoomCombinationItem) {
            // validation for constraint: itemType
            if (!$bookingOptionsRoomCombinationItem instanceof \StructType\RoomCombination) {
                throw new \InvalidArgumentException(sprintf('The RoomCombination property can only contain items of \StructType\RoomCombination, "%s" given', is_object($bookingOptionsRoomCombinationItem) ? get_class($bookingOptionsRoomCombinationItem) : gettype($bookingOptionsRoomCombinationItem)), __LINE__);
            }
        }
        $this->RoomCombination = $roomCombination;
        return $this;
    }
    /**
     * Add item to RoomCombination value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCombination $item
     * @return \StructType\BookingOptions
     */
    public function addToRoomCombination(\StructType\RoomCombination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomCombination) {
            throw new \InvalidArgumentException(sprintf('The RoomCombination property can only contain items of \StructType\RoomCombination, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomCombination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
