<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAndPricingResponse StructType
 * @subpackage Structs
 */
class AvailabilityAndPricingResponse extends AbstractStructBase
{
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The AvailableForBook
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AvailableForBook;
    /**
     * The AvailableForConfirmBook
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AvailableForConfirmBook;
    /**
     * The CancellationPoliciesAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CancellationPoliciesAvailable;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseStatus
     */
    public $Status;
    /**
     * The HotelCancellationPolicies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelCancellationPolicies
     */
    public $HotelCancellationPolicies;
    /**
     * The PriceVerification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceVerification
     */
    public $PriceVerification;
    /**
     * The AccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountInfo
     */
    public $AccountInfo;
    /**
     * The HotelDetailsVerification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelDetailsVerification
     */
    public $HotelDetailsVerification;
    /**
     * The HotelDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\APIHotelDetails
     */
    public $HotelDetails;
    /**
     * Constructor method for AvailabilityAndPricingResponse
     * @uses AvailabilityAndPricingResponse::setResultIndex()
     * @uses AvailabilityAndPricingResponse::setAvailableForBook()
     * @uses AvailabilityAndPricingResponse::setAvailableForConfirmBook()
     * @uses AvailabilityAndPricingResponse::setCancellationPoliciesAvailable()
     * @uses AvailabilityAndPricingResponse::setStatus()
     * @uses AvailabilityAndPricingResponse::setHotelCancellationPolicies()
     * @uses AvailabilityAndPricingResponse::setPriceVerification()
     * @uses AvailabilityAndPricingResponse::setAccountInfo()
     * @uses AvailabilityAndPricingResponse::setHotelDetailsVerification()
     * @uses AvailabilityAndPricingResponse::setHotelDetails()
     * @param int $resultIndex
     * @param bool $availableForBook
     * @param bool $availableForConfirmBook
     * @param bool $cancellationPoliciesAvailable
     * @param \StructType\ResponseStatus $status
     * @param \StructType\HotelCancellationPolicies $hotelCancellationPolicies
     * @param \StructType\PriceVerification $priceVerification
     * @param \StructType\AccountInfo $accountInfo
     * @param \StructType\HotelDetailsVerification $hotelDetailsVerification
     * @param \StructType\APIHotelDetails $hotelDetails
     */
    public function __construct($resultIndex = null, $availableForBook = null, $availableForConfirmBook = null, $cancellationPoliciesAvailable = null, \StructType\ResponseStatus $status = null, \StructType\HotelCancellationPolicies $hotelCancellationPolicies = null, \StructType\PriceVerification $priceVerification = null, \StructType\AccountInfo $accountInfo = null, \StructType\HotelDetailsVerification $hotelDetailsVerification = null, \StructType\APIHotelDetails $hotelDetails = null)
    {
        $this
            ->setResultIndex($resultIndex)
            ->setAvailableForBook($availableForBook)
            ->setAvailableForConfirmBook($availableForConfirmBook)
            ->setCancellationPoliciesAvailable($cancellationPoliciesAvailable)
            ->setStatus($status)
            ->setHotelCancellationPolicies($hotelCancellationPolicies)
            ->setPriceVerification($priceVerification)
            ->setAccountInfo($accountInfo)
            ->setHotelDetailsVerification($hotelDetailsVerification)
            ->setHotelDetails($hotelDetails);
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get AvailableForBook value
     * @return bool
     */
    public function getAvailableForBook()
    {
        return $this->AvailableForBook;
    }
    /**
     * Set AvailableForBook value
     * @param bool $availableForBook
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setAvailableForBook($availableForBook = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForBook) && !is_bool($availableForBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableForBook)), __LINE__);
        }
        $this->AvailableForBook = $availableForBook;
        return $this;
    }
    /**
     * Get AvailableForConfirmBook value
     * @return bool
     */
    public function getAvailableForConfirmBook()
    {
        return $this->AvailableForConfirmBook;
    }
    /**
     * Set AvailableForConfirmBook value
     * @param bool $availableForConfirmBook
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setAvailableForConfirmBook($availableForConfirmBook = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForConfirmBook) && !is_bool($availableForConfirmBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableForConfirmBook)), __LINE__);
        }
        $this->AvailableForConfirmBook = $availableForConfirmBook;
        return $this;
    }
    /**
     * Get CancellationPoliciesAvailable value
     * @return bool
     */
    public function getCancellationPoliciesAvailable()
    {
        return $this->CancellationPoliciesAvailable;
    }
    /**
     * Set CancellationPoliciesAvailable value
     * @param bool $cancellationPoliciesAvailable
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setCancellationPoliciesAvailable($cancellationPoliciesAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationPoliciesAvailable) && !is_bool($cancellationPoliciesAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancellationPoliciesAvailable)), __LINE__);
        }
        $this->CancellationPoliciesAvailable = $cancellationPoliciesAvailable;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ResponseStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ResponseStatus $status
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setStatus(\StructType\ResponseStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get HotelCancellationPolicies value
     * @return \StructType\HotelCancellationPolicies|null
     */
    public function getHotelCancellationPolicies()
    {
        return $this->HotelCancellationPolicies;
    }
    /**
     * Set HotelCancellationPolicies value
     * @param \StructType\HotelCancellationPolicies $hotelCancellationPolicies
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setHotelCancellationPolicies(\StructType\HotelCancellationPolicies $hotelCancellationPolicies = null)
    {
        $this->HotelCancellationPolicies = $hotelCancellationPolicies;
        return $this;
    }
    /**
     * Get PriceVerification value
     * @return \StructType\PriceVerification|null
     */
    public function getPriceVerification()
    {
        return $this->PriceVerification;
    }
    /**
     * Set PriceVerification value
     * @param \StructType\PriceVerification $priceVerification
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setPriceVerification(\StructType\PriceVerification $priceVerification = null)
    {
        $this->PriceVerification = $priceVerification;
        return $this;
    }
    /**
     * Get AccountInfo value
     * @return \StructType\AccountInfo|null
     */
    public function getAccountInfo()
    {
        return $this->AccountInfo;
    }
    /**
     * Set AccountInfo value
     * @param \StructType\AccountInfo $accountInfo
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setAccountInfo(\StructType\AccountInfo $accountInfo = null)
    {
        $this->AccountInfo = $accountInfo;
        return $this;
    }
    /**
     * Get HotelDetailsVerification value
     * @return \StructType\HotelDetailsVerification|null
     */
    public function getHotelDetailsVerification()
    {
        return $this->HotelDetailsVerification;
    }
    /**
     * Set HotelDetailsVerification value
     * @param \StructType\HotelDetailsVerification $hotelDetailsVerification
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setHotelDetailsVerification(\StructType\HotelDetailsVerification $hotelDetailsVerification = null)
    {
        $this->HotelDetailsVerification = $hotelDetailsVerification;
        return $this;
    }
    /**
     * Get HotelDetails value
     * @return \StructType\APIHotelDetails|null
     */
    public function getHotelDetails()
    {
        return $this->HotelDetails;
    }
    /**
     * Set HotelDetails value
     * @param \StructType\APIHotelDetails $hotelDetails
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public function setHotelDetails(\StructType\APIHotelDetails $hotelDetails = null)
    {
        $this->HotelDetails = $hotelDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityAndPricingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
