<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityAndPricingRequest StructType
 * @subpackage Structs
 */
class AvailabilityAndPricingRequest extends AbstractStructBase
{
    /**
     * The ResultIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultIndex;
    /**
     * The SessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionId;
    /**
     * The OptionsForBooking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingOptions
     */
    public $OptionsForBooking;
    /**
     * Constructor method for AvailabilityAndPricingRequest
     * @uses AvailabilityAndPricingRequest::setResultIndex()
     * @uses AvailabilityAndPricingRequest::setSessionId()
     * @uses AvailabilityAndPricingRequest::setOptionsForBooking()
     * @param int $resultIndex
     * @param string $sessionId
     * @param \StructType\BookingOptions $optionsForBooking
     */
    public function __construct($resultIndex = null, $sessionId = null, \StructType\BookingOptions $optionsForBooking = null)
    {
        $this
            ->setResultIndex($resultIndex)
            ->setSessionId($sessionId)
            ->setOptionsForBooking($optionsForBooking);
    }
    /**
     * Get ResultIndex value
     * @return int
     */
    public function getResultIndex()
    {
        return $this->ResultIndex;
    }
    /**
     * Set ResultIndex value
     * @param int $resultIndex
     * @return \StructType\AvailabilityAndPricingRequest
     */
    public function setResultIndex($resultIndex = null)
    {
        // validation for constraint: int
        if (!is_null($resultIndex) && !is_numeric($resultIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultIndex)), __LINE__);
        }
        $this->ResultIndex = $resultIndex;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\AvailabilityAndPricingRequest
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get OptionsForBooking value
     * @return \StructType\BookingOptions|null
     */
    public function getOptionsForBooking()
    {
        return $this->OptionsForBooking;
    }
    /**
     * Set OptionsForBooking value
     * @param \StructType\BookingOptions $optionsForBooking
     * @return \StructType\AvailabilityAndPricingRequest
     */
    public function setOptionsForBooking(\StructType\BookingOptions $optionsForBooking = null)
    {
        $this->OptionsForBooking = $optionsForBooking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityAndPricingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
