<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmendmentDetails StructType
 * @subpackage Structs
 */
class AmendmentDetails extends AbstractStructBase
{
    /**
     * The BeforeAmendmentPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $BeforeAmendmentPrice;
    /**
     * The AfterAmendmentPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $AfterAmendmentPrice;
    /**
     * The CreditNoteAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $CreditNoteAmount;
    /**
     * The DebitNoteAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $DebitNoteAmount;
    /**
     * Constructor method for AmendmentDetails
     * @uses AmendmentDetails::setBeforeAmendmentPrice()
     * @uses AmendmentDetails::setAfterAmendmentPrice()
     * @uses AmendmentDetails::setCreditNoteAmount()
     * @uses AmendmentDetails::setDebitNoteAmount()
     * @param float $beforeAmendmentPrice
     * @param float $afterAmendmentPrice
     * @param float $creditNoteAmount
     * @param float $debitNoteAmount
     */
    public function __construct($beforeAmendmentPrice = null, $afterAmendmentPrice = null, $creditNoteAmount = null, $debitNoteAmount = null)
    {
        $this
            ->setBeforeAmendmentPrice($beforeAmendmentPrice)
            ->setAfterAmendmentPrice($afterAmendmentPrice)
            ->setCreditNoteAmount($creditNoteAmount)
            ->setDebitNoteAmount($debitNoteAmount);
    }
    /**
     * Get BeforeAmendmentPrice value
     * @return float
     */
    public function getBeforeAmendmentPrice()
    {
        return $this->BeforeAmendmentPrice;
    }
    /**
     * Set BeforeAmendmentPrice value
     * @param float $beforeAmendmentPrice
     * @return \StructType\AmendmentDetails
     */
    public function setBeforeAmendmentPrice($beforeAmendmentPrice = null)
    {
        $this->BeforeAmendmentPrice = $beforeAmendmentPrice;
        return $this;
    }
    /**
     * Get AfterAmendmentPrice value
     * @return float
     */
    public function getAfterAmendmentPrice()
    {
        return $this->AfterAmendmentPrice;
    }
    /**
     * Set AfterAmendmentPrice value
     * @param float $afterAmendmentPrice
     * @return \StructType\AmendmentDetails
     */
    public function setAfterAmendmentPrice($afterAmendmentPrice = null)
    {
        $this->AfterAmendmentPrice = $afterAmendmentPrice;
        return $this;
    }
    /**
     * Get CreditNoteAmount value
     * @return float
     */
    public function getCreditNoteAmount()
    {
        return $this->CreditNoteAmount;
    }
    /**
     * Set CreditNoteAmount value
     * @param float $creditNoteAmount
     * @return \StructType\AmendmentDetails
     */
    public function setCreditNoteAmount($creditNoteAmount = null)
    {
        $this->CreditNoteAmount = $creditNoteAmount;
        return $this;
    }
    /**
     * Get DebitNoteAmount value
     * @return float
     */
    public function getDebitNoteAmount()
    {
        return $this->DebitNoteAmount;
    }
    /**
     * Set DebitNoteAmount value
     * @param float $debitNoteAmount
     * @return \StructType\AmendmentDetails
     */
    public function setDebitNoteAmount($debitNoteAmount = null)
    {
        $this->DebitNoteAmount = $debitNoteAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmendmentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
