<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInfo StructType
 * @subpackage Structs
 */
class AccountInfo extends AbstractStructBase
{
    /**
     * The AgencyBalance
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $AgencyBalance;
    /**
     * The AgencyBlocked
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AgencyBlocked;
    /**
     * Constructor method for AccountInfo
     * @uses AccountInfo::setAgencyBalance()
     * @uses AccountInfo::setAgencyBlocked()
     * @param string $agencyBalance
     * @param bool $agencyBlocked
     */
    public function __construct($agencyBalance = null, $agencyBlocked = null)
    {
        $this
            ->setAgencyBalance($agencyBalance)
            ->setAgencyBlocked($agencyBlocked);
    }
    /**
     * Get AgencyBalance value
     * @return string
     */
    public function getAgencyBalance()
    {
        return $this->AgencyBalance;
    }
    /**
     * Set AgencyBalance value
     * @uses \EnumType\AccountBalance::valueIsValid()
     * @uses \EnumType\AccountBalance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agencyBalance
     * @return \StructType\AccountInfo
     */
    public function setAgencyBalance($agencyBalance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountBalance::valueIsValid($agencyBalance)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $agencyBalance, implode(', ', \EnumType\AccountBalance::getValidValues())), __LINE__);
        }
        $this->AgencyBalance = $agencyBalance;
        return $this;
    }
    /**
     * Get AgencyBlocked value
     * @return bool
     */
    public function getAgencyBlocked()
    {
        return $this->AgencyBlocked;
    }
    /**
     * Set AgencyBlocked value
     * @param bool $agencyBlocked
     * @return \StructType\AccountInfo
     */
    public function setAgencyBlocked($agencyBlocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($agencyBlocked) && !is_bool($agencyBlocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($agencyBlocked)), __LINE__);
        }
        $this->AgencyBlocked = $agencyBlocked;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
