<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Giata ServiceType
 * @subpackage Services
 */
class Giata extends AbstractSoapClientBase
{
    /**
     * Sets the Credentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticationData $credentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderCredentials(\StructType\AuthenticationData $credentials, $nameSpace = 'http://TekTravel/HotelBookingApi', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Credentials', $credentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GiataHotelCodeList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Credentials
     * - SOAPHeaderNamespaces: http://TekTravel/HotelBookingApi
     * - SOAPHeaderTypes: \StructType\AuthenticationData
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GiataHotelCodesRequest $parameters
     * @return \StructType\GiataHotelCodesResponse|bool
     */
    public function GiataHotelCodeList(\StructType\GiataHotelCodesRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GiataHotelCodeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GiataHotelCodesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
