<?php

namespace EnumType;

/**
 * This class stands for RequestStatus EnumType
 * @subpackage Enumerations
 */
class RequestStatus
{
    /**
     * Constant for value 'Unprocessed'
     * @return string 'Unprocessed'
     */
    const VALUE_UNPROCESSED = 'Unprocessed';
    /**
     * Constant for value 'RequestSent'
     * @return string 'RequestSent'
     */
    const VALUE_REQUEST_SENT = 'RequestSent';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Constant for value 'AgentApprovalPending'
     * @return string 'AgentApprovalPending'
     */
    const VALUE_AGENT_APPROVAL_PENDING = 'AgentApprovalPending';
    /**
     * Constant for value 'PendingWithSupplier'
     * @return string 'PendingWithSupplier'
     */
    const VALUE_PENDING_WITH_SUPPLIER = 'PendingWithSupplier';
    /**
     * Constant for value 'Amended'
     * @return string 'Amended'
     */
    const VALUE_AMENDED = 'Amended';
    /**
     * Constant for value 'Withdrawn'
     * @return string 'Withdrawn'
     */
    const VALUE_WITHDRAWN = 'Withdrawn';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'NotRequested'
     * @return string 'NotRequested'
     */
    const VALUE_NOT_REQUESTED = 'NotRequested';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNPROCESSED
     * @uses self::VALUE_REQUEST_SENT
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_AGENT_APPROVAL_PENDING
     * @uses self::VALUE_PENDING_WITH_SUPPLIER
     * @uses self::VALUE_AMENDED
     * @uses self::VALUE_WITHDRAWN
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_NOT_REQUESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNPROCESSED,
            self::VALUE_REQUEST_SENT,
            self::VALUE_IN_PROGRESS,
            self::VALUE_AGENT_APPROVAL_PENDING,
            self::VALUE_PENDING_WITH_SUPPLIER,
            self::VALUE_AMENDED,
            self::VALUE_WITHDRAWN,
            self::VALUE_REJECTED,
            self::VALUE_CANCELLED,
            self::VALUE_NOT_REQUESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
