<?php

namespace EnumType;

/**
 * This class stands for PriceChange EnumType
 * @subpackage Enumerations
 */
class PriceChange
{
    /**
     * Constant for value 'InformationRequired'
     * @return string 'InformationRequired'
     */
    const VALUE_INFORMATION_REQUIRED = 'InformationRequired';
    /**
     * Constant for value 'Approved'
     * @return string 'Approved'
     */
    const VALUE_APPROVED = 'Approved';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFORMATION_REQUIRED
     * @uses self::VALUE_APPROVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFORMATION_REQUIRED,
            self::VALUE_APPROVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
