<?php

namespace EnumType;

/**
 * This class stands for HotelInfoHotelRating EnumType
 * @subpackage Enumerations
 */
class HotelInfoHotelRating
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'OneStar'
     * @return string 'OneStar'
     */
    const VALUE_ONE_STAR = 'OneStar';
    /**
     * Constant for value 'TwoStar'
     * @return string 'TwoStar'
     */
    const VALUE_TWO_STAR = 'TwoStar';
    /**
     * Constant for value 'ThreeStar'
     * @return string 'ThreeStar'
     */
    const VALUE_THREE_STAR = 'ThreeStar';
    /**
     * Constant for value 'FourStar'
     * @return string 'FourStar'
     */
    const VALUE_FOUR_STAR = 'FourStar';
    /**
     * Constant for value 'FiveStar'
     * @return string 'FiveStar'
     */
    const VALUE_FIVE_STAR = 'FiveStar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ONE_STAR
     * @uses self::VALUE_TWO_STAR
     * @uses self::VALUE_THREE_STAR
     * @uses self::VALUE_FOUR_STAR
     * @uses self::VALUE_FIVE_STAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ONE_STAR,
            self::VALUE_TWO_STAR,
            self::VALUE_THREE_STAR,
            self::VALUE_FOUR_STAR,
            self::VALUE_FIVE_STAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
