<?php

namespace EnumType;

/**
 * This class stands for HotelCancelStatus EnumType
 * @subpackage Enumerations
 */
class HotelCancelStatus
{
    /**
     * Constant for value 'UnProcessed'
     * @return string 'UnProcessed'
     */
    const VALUE_UN_PROCESSED = 'UnProcessed';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Constant for value 'Processed'
     * @return string 'Processed'
     */
    const VALUE_PROCESSED = 'Processed';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UN_PROCESSED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_PROCESSED
     * @uses self::VALUE_REJECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UN_PROCESSED,
            self::VALUE_PENDING,
            self::VALUE_IN_PROGRESS,
            self::VALUE_PROCESSED,
            self::VALUE_REJECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
