<?php

namespace EnumType;

/**
 * This class stands for CancellationChargeTypeForHotel EnumType
 * @subpackage Enumerations
 */
class CancellationChargeTypeForHotel
{
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Constant for value 'Night'
     * @return string 'Night'
     */
    const VALUE_NIGHT = 'Night';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_PERCENTAGE
     * @uses self::VALUE_NIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED,
            self::VALUE_PERCENTAGE,
            self::VALUE_NIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
