<?php

namespace EnumType;

/**
 * This class stands for CancelRequestType EnumType
 * @subpackage Enumerations
 */
class CancelRequestType
{
    /**
     * Constant for value 'HotelCancel'
     * @return string 'HotelCancel'
     */
    const VALUE_HOTEL_CANCEL = 'HotelCancel';
    /**
     * Constant for value 'CheckStatus'
     * @return string 'CheckStatus'
     */
    const VALUE_CHECK_STATUS = 'CheckStatus';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOTEL_CANCEL
     * @uses self::VALUE_CHECK_STATUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOTEL_CANCEL,
            self::VALUE_CHECK_STATUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
