<?php

namespace EnumType;

/**
 * This class stands for AmendmentType EnumType
 * @subpackage Enumerations
 */
class AmendmentType
{
    /**
     * Constant for value 'CheckStatus'
     * @return string 'CheckStatus'
     */
    const VALUE_CHECK_STATUS = 'CheckStatus';
    /**
     * Constant for value 'OfflineAmendment'
     * @return string 'OfflineAmendment'
     */
    const VALUE_OFFLINE_AMENDMENT = 'OfflineAmendment';
    /**
     * Constant for value 'PriceApproved'
     * @return string 'PriceApproved'
     */
    const VALUE_PRICE_APPROVED = 'PriceApproved';
    /**
     * Constant for value 'WithdrawRequest'
     * @return string 'WithdrawRequest'
     */
    const VALUE_WITHDRAW_REQUEST = 'WithdrawRequest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECK_STATUS
     * @uses self::VALUE_OFFLINE_AMENDMENT
     * @uses self::VALUE_PRICE_APPROVED
     * @uses self::VALUE_WITHDRAW_REQUEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECK_STATUS,
            self::VALUE_OFFLINE_AMENDMENT,
            self::VALUE_PRICE_APPROVED,
            self::VALUE_WITHDRAW_REQUEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
