<?php

namespace EnumType;

/**
 * This class stands for AmendActionRes EnumType
 * @subpackage Enumerations
 */
class AmendActionRes
{
    /**
     * Constant for value 'Retained'
     * @return string 'Retained'
     */
    const VALUE_RETAINED = 'Retained';
    /**
     * Constant for value 'Added'
     * @return string 'Added'
     */
    const VALUE_ADDED = 'Added';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Renamed'
     * @return string 'Renamed'
     */
    const VALUE_RENAMED = 'Renamed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RETAINED
     * @uses self::VALUE_ADDED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_RENAMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RETAINED,
            self::VALUE_ADDED,
            self::VALUE_DELETED,
            self::VALUE_RENAMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
