<?php

namespace EnumType;

/**
 * This class stands for AccountBalance EnumType
 * @subpackage Enumerations
 */
class AccountBalance
{
    /**
     * Constant for value 'Sufficient'
     * @return string 'Sufficient'
     */
    const VALUE_SUFFICIENT = 'Sufficient';
    /**
     * Constant for value 'InSufficient'
     * @return string 'InSufficient'
     */
    const VALUE_IN_SUFFICIENT = 'InSufficient';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUFFICIENT
     * @uses self::VALUE_IN_SUFFICIENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUFFICIENT,
            self::VALUE_IN_SUFFICIENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
