<?php

namespace EnumType;

/**
 * This class stands for APIHotelBookingStatus EnumType
 * @subpackage Enumerations
 */
class APIHotelBookingStatus
{
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'Vouchered'
     * @return string 'Vouchered'
     */
    const VALUE_VOUCHERED = 'Vouchered';
    /**
     * Constant for value 'CancellationInProgress'
     * @return string 'CancellationInProgress'
     */
    const VALUE_CANCELLATION_IN_PROGRESS = 'CancellationInProgress';
    /**
     * Constant for value 'CxlRequestSentToHotel'
     * @return string 'CxlRequestSentToHotel'
     */
    const VALUE_CXL_REQUEST_SENT_TO_HOTEL = 'CxlRequestSentToHotel';
    /**
     * Constant for value 'WaitingForPayment'
     * @return string 'WaitingForPayment'
     */
    const VALUE_WAITING_FOR_PAYMENT = 'WaitingForPayment';
    /**
     * Constant for value 'CancelledAndRefundAwaited'
     * @return string 'CancelledAndRefundAwaited'
     */
    const VALUE_CANCELLED_AND_REFUND_AWAITED = 'CancelledAndRefundAwaited';
    /**
     * Constant for value 'Requested'
     * @return string 'Requested'
     */
    const VALUE_REQUESTED = 'Requested';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_VOUCHERED
     * @uses self::VALUE_CANCELLATION_IN_PROGRESS
     * @uses self::VALUE_CXL_REQUEST_SENT_TO_HOTEL
     * @uses self::VALUE_WAITING_FOR_PAYMENT
     * @uses self::VALUE_CANCELLED_AND_REFUND_AWAITED
     * @uses self::VALUE_REQUESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAILED,
            self::VALUE_CONFIRMED,
            self::VALUE_CANCELLED,
            self::VALUE_PENDING,
            self::VALUE_REJECTED,
            self::VALUE_VOUCHERED,
            self::VALUE_CANCELLATION_IN_PROGRESS,
            self::VALUE_CXL_REQUEST_SENT_TO_HOTEL,
            self::VALUE_WAITING_FOR_PAYMENT,
            self::VALUE_CANCELLED_AND_REFUND_AWAITED,
            self::VALUE_REQUESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
