<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTagInfos ArrayType
 * @subpackage Arrays
 */
class ArrayOfTagInfos extends AbstractStructArrayBase
{
    /**
     * The TagInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TagInfos[]
     */
    public $TagInfo;
    /**
     * Constructor method for ArrayOfTagInfos
     * @uses ArrayOfTagInfos::setTagInfo()
     * @param \StructType\TagInfos[] $tagInfo
     */
    public function __construct(array $tagInfo = array())
    {
        $this
            ->setTagInfo($tagInfo);
    }
    /**
     * Get TagInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TagInfos[]|null
     */
    public function getTagInfo()
    {
        return isset($this->TagInfo) ? $this->TagInfo : null;
    }
    /**
     * Set TagInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TagInfos[] $tagInfo
     * @return \ArrayType\ArrayOfTagInfos
     */
    public function setTagInfo(array $tagInfo = array())
    {
        foreach ($tagInfo as $arrayOfTagInfosTagInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTagInfosTagInfoItem instanceof \StructType\TagInfos) {
                throw new \InvalidArgumentException(sprintf('The TagInfo property can only contain items of \StructType\TagInfos, "%s" given', is_object($arrayOfTagInfosTagInfoItem) ? get_class($arrayOfTagInfosTagInfoItem) : gettype($arrayOfTagInfosTagInfoItem)), __LINE__);
            }
        }
        if (is_null($tagInfo) || (is_array($tagInfo) && empty($tagInfo))) {
            unset($this->TagInfo);
        } else {
            $this->TagInfo = $tagInfo;
        }
        return $this;
    }
    /**
     * Add item to TagInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TagInfos $item
     * @return \ArrayType\ArrayOfTagInfos
     */
    public function addToTagInfo(\StructType\TagInfos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TagInfos) {
            throw new \InvalidArgumentException(sprintf('The TagInfo property can only contain items of \StructType\TagInfos, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TagInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TagInfos|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TagInfos|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TagInfos|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TagInfos|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TagInfos|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TagInfo
     */
    public function getAttributeName()
    {
        return 'TagInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTagInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
