<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSupp_info ArrayType
 * @subpackage Arrays
 */
class ArrayOfSupp_info extends AbstractStructArrayBase
{
    /**
     * The Supp_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Supp_info[]
     */
    public $Supp_info;
    /**
     * Constructor method for ArrayOfSupp_info
     * @uses ArrayOfSupp_info::setSupp_info()
     * @param \StructType\Supp_info[] $supp_info
     */
    public function __construct(array $supp_info = array())
    {
        $this
            ->setSupp_info($supp_info);
    }
    /**
     * Get Supp_info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Supp_info[]|null
     */
    public function getSupp_info()
    {
        return isset($this->Supp_info) ? $this->Supp_info : null;
    }
    /**
     * Set Supp_info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supp_info[] $supp_info
     * @return \ArrayType\ArrayOfSupp_info
     */
    public function setSupp_info(array $supp_info = array())
    {
        foreach ($supp_info as $arrayOfSupp_infoSupp_infoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSupp_infoSupp_infoItem instanceof \StructType\Supp_info) {
                throw new \InvalidArgumentException(sprintf('The Supp_info property can only contain items of \StructType\Supp_info, "%s" given', is_object($arrayOfSupp_infoSupp_infoItem) ? get_class($arrayOfSupp_infoSupp_infoItem) : gettype($arrayOfSupp_infoSupp_infoItem)), __LINE__);
            }
        }
        if (is_null($supp_info) || (is_array($supp_info) && empty($supp_info))) {
            unset($this->Supp_info);
        } else {
            $this->Supp_info = $supp_info;
        }
        return $this;
    }
    /**
     * Add item to Supp_info value
     * @throws \InvalidArgumentException
     * @param \StructType\Supp_info $item
     * @return \ArrayType\ArrayOfSupp_info
     */
    public function addToSupp_info(\StructType\Supp_info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supp_info) {
            throw new \InvalidArgumentException(sprintf('The Supp_info property can only contain items of \StructType\Supp_info, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supp_info[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Supp_info|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Supp_info|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Supp_info|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Supp_info|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Supp_info|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Supp_info
     */
    public function getAttributeName()
    {
        return 'Supp_info';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSupp_info
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
