<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSuppInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfSuppInfo extends AbstractStructArrayBase
{
    /**
     * The SuppInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SuppInfo[]
     */
    public $SuppInfo;
    /**
     * Constructor method for ArrayOfSuppInfo
     * @uses ArrayOfSuppInfo::setSuppInfo()
     * @param \StructType\SuppInfo[] $suppInfo
     */
    public function __construct(array $suppInfo = array())
    {
        $this
            ->setSuppInfo($suppInfo);
    }
    /**
     * Get SuppInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SuppInfo[]|null
     */
    public function getSuppInfo()
    {
        return isset($this->SuppInfo) ? $this->SuppInfo : null;
    }
    /**
     * Set SuppInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuppInfo[] $suppInfo
     * @return \ArrayType\ArrayOfSuppInfo
     */
    public function setSuppInfo(array $suppInfo = array())
    {
        foreach ($suppInfo as $arrayOfSuppInfoSuppInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSuppInfoSuppInfoItem instanceof \StructType\SuppInfo) {
                throw new \InvalidArgumentException(sprintf('The SuppInfo property can only contain items of \StructType\SuppInfo, "%s" given', is_object($arrayOfSuppInfoSuppInfoItem) ? get_class($arrayOfSuppInfoSuppInfoItem) : gettype($arrayOfSuppInfoSuppInfoItem)), __LINE__);
            }
        }
        if (is_null($suppInfo) || (is_array($suppInfo) && empty($suppInfo))) {
            unset($this->SuppInfo);
        } else {
            $this->SuppInfo = $suppInfo;
        }
        return $this;
    }
    /**
     * Add item to SuppInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SuppInfo $item
     * @return \ArrayType\ArrayOfSuppInfo
     */
    public function addToSuppInfo(\StructType\SuppInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuppInfo) {
            throw new \InvalidArgumentException(sprintf('The SuppInfo property can only contain items of \StructType\SuppInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SuppInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SuppInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SuppInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SuppInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SuppInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SuppInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SuppInfo
     */
    public function getAttributeName()
    {
        return 'SuppInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSuppInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
