<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for ArrayOfSpecialRequest
     * @uses ArrayOfSpecialRequest::setSpecialRequest()
     * @param \StructType\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return isset($this->SpecialRequest) ? $this->SpecialRequest : null;
    }
    /**
     * Set SpecialRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest[] $specialRequest
     * @return \ArrayType\ArrayOfSpecialRequest
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        foreach ($specialRequest as $arrayOfSpecialRequestSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestSpecialRequestItem instanceof \StructType\SpecialRequest) {
                throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \StructType\SpecialRequest, "%s" given', is_object($arrayOfSpecialRequestSpecialRequestItem) ? get_class($arrayOfSpecialRequestSpecialRequestItem) : gettype($arrayOfSpecialRequestSpecialRequestItem)), __LINE__);
            }
        }
        if (is_null($specialRequest) || (is_array($specialRequest) && empty($specialRequest))) {
            unset($this->SpecialRequest);
        } else {
            $this->SpecialRequest = $specialRequest;
        }
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest $item
     * @return \ArrayType\ArrayOfSpecialRequest
     */
    public function addToSpecialRequest(\StructType\SpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \StructType\SpecialRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequest
     */
    public function getAttributeName()
    {
        return 'SpecialRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
