<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomReq ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomReq extends AbstractStructArrayBase
{
    /**
     * The RoomReq
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoomReq[]
     */
    public $RoomReq;
    /**
     * Constructor method for ArrayOfRoomReq
     * @uses ArrayOfRoomReq::setRoomReq()
     * @param \StructType\RoomReq[] $roomReq
     */
    public function __construct(array $roomReq = array())
    {
        $this
            ->setRoomReq($roomReq);
    }
    /**
     * Get RoomReq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoomReq[]|null
     */
    public function getRoomReq()
    {
        return isset($this->RoomReq) ? $this->RoomReq : null;
    }
    /**
     * Set RoomReq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoomReq[] $roomReq
     * @return \ArrayType\ArrayOfRoomReq
     */
    public function setRoomReq(array $roomReq = array())
    {
        foreach ($roomReq as $arrayOfRoomReqRoomReqItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomReqRoomReqItem instanceof \StructType\RoomReq) {
                throw new \InvalidArgumentException(sprintf('The RoomReq property can only contain items of \StructType\RoomReq, "%s" given', is_object($arrayOfRoomReqRoomReqItem) ? get_class($arrayOfRoomReqRoomReqItem) : gettype($arrayOfRoomReqRoomReqItem)), __LINE__);
            }
        }
        if (is_null($roomReq) || (is_array($roomReq) && empty($roomReq))) {
            unset($this->RoomReq);
        } else {
            $this->RoomReq = $roomReq;
        }
        return $this;
    }
    /**
     * Add item to RoomReq value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomReq $item
     * @return \ArrayType\ArrayOfRoomReq
     */
    public function addToRoomReq(\StructType\RoomReq $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomReq) {
            throw new \InvalidArgumentException(sprintf('The RoomReq property can only contain items of \StructType\RoomReq, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomReq[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomReq|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomReq|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomReq|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomReq|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomReq|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomReq
     */
    public function getAttributeName()
    {
        return 'RoomReq';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoomReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
